/*
 * Decompiled with CFR 0.152.
 */
package com.lowdragmc.lowdraglib.misc;

import com.lowdragmc.lowdraglib.syncdata.AccessorOp;
import com.lowdragmc.lowdraglib.syncdata.IAccessor;
import com.lowdragmc.lowdraglib.syncdata.IContentChangeAware;
import com.lowdragmc.lowdraglib.syncdata.ITagSerializable;
import com.lowdragmc.lowdraglib.syncdata.TypedPayloadRegistries;
import com.lowdragmc.lowdraglib.syncdata.accessor.ManagedAccessor;
import com.lowdragmc.lowdraglib.syncdata.managed.ManagedHolder;
import com.lowdragmc.lowdraglib.syncdata.payload.ITypedPayload;
import com.lowdragmc.lowdraglib.syncdata.payload.PrimitiveTypedPayload;
import com.lowdragmc.lowdraglib.utils.ReflectionUtils;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nullable;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import org.jetbrains.annotations.NotNull;

public abstract class SyncableMap<K, V>
implements Map<K, V>,
IContentChangeAware,
ITagSerializable<Tag> {
    private final IAccessor keyAccessor;
    private final IAccessor valueAccessor;
    private final Class<?> keyType;
    private final Class<?> valueType;
    private boolean stringKey = false;
    private final Map<K, V> map = new HashMap();
    private Runnable onContentsChanged = () -> {};

    public SyncableMap() {
        Class<?> clazz = this.getClass();
        Type parent = clazz.getGenericSuperclass();
        Type keyType = ((ParameterizedType)parent).getActualTypeArguments()[0];
        Type valueType = ((ParameterizedType)parent).getActualTypeArguments()[1];
        this.keyType = ReflectionUtils.getRawType(keyType, Object.class);
        this.valueType = ReflectionUtils.getRawType(valueType, Object.class);
        this.stringKey = keyType == String.class;
        this.keyAccessor = TypedPayloadRegistries.findByType(keyType);
        this.valueAccessor = TypedPayloadRegistries.findByType(valueType);
        if (this.keyAccessor == null || this.valueAccessor == null) {
            throw new RuntimeException("Cannot find accessor for key or value type");
        }
        if (!this.keyAccessor.isManaged()) {
            throw new RuntimeException("Key accessor is not managed");
        }
        if (!this.valueAccessor.isManaged()) {
            throw new RuntimeException("Value accessor is not managed");
        }
    }

    @Override
    public int size() {
        return this.map.size();
    }

    @Override
    public boolean isEmpty() {
        return this.map.isEmpty();
    }

    @Override
    public boolean containsKey(Object key) {
        return this.map.containsKey(key);
    }

    @Override
    public boolean containsValue(Object value) {
        return this.map.containsValue(value);
    }

    @Override
    public V get(Object key) {
        return this.map.get(key);
    }

    @Override
    @Nullable
    public V put(K key, V value) {
        V result = this.map.put(key, value);
        this.onContentsChanged.run();
        return result;
    }

    @Override
    public V remove(Object key) {
        V result = this.map.remove(key);
        this.onContentsChanged.run();
        return result;
    }

    @Override
    public void putAll(@NotNull Map<? extends K, ? extends V> m) {
        this.map.putAll(m);
        this.onContentsChanged.run();
    }

    @Override
    public void clear() {
        this.map.clear();
        this.onContentsChanged.run();
    }

    @Override
    @NotNull
    public Set<K> keySet() {
        return this.map.keySet();
    }

    @Override
    @NotNull
    public Collection<V> values() {
        return this.map.values();
    }

    @Override
    @NotNull
    public Set<Map.Entry<K, V>> entrySet() {
        return this.map.entrySet();
    }

    private static Tag readVal(ManagedAccessor accessor, Object val) {
        return val == null ? PrimitiveTypedPayload.ofNull().serializeNBT() : accessor.readManagedField(AccessorOp.PERSISTED, ManagedHolder.of(val)).serializeNBT();
    }

    private static Object writeVal(ManagedAccessor accessor, Tag val, Class<?> type) {
        if (val == null) {
            return null;
        }
        ManagedHolder<?> holder = ManagedHolder.ofType(type);
        ITypedPayload<?> payload = TypedPayloadRegistries.create(accessor.getDefaultType());
        payload.deserializeNBT(val);
        accessor.writeManagedField(AccessorOp.PERSISTED, holder, payload);
        return holder.value();
    }

    @Override
    public Tag serializeNBT() {
        if (this.stringKey) {
            CompoundTag tag = new CompoundTag();
            for (Map.Entry<K, V> entry : this.map.entrySet()) {
                Tag valueTag = SyncableMap.readVal((ManagedAccessor)this.valueAccessor, entry.getValue());
                tag.put((String)entry.getKey(), valueTag);
            }
            return tag;
        }
        ListTag list = new ListTag();
        this.map.forEach((k, v) -> {
            CompoundTag tag = new CompoundTag();
            Tag keyTag = SyncableMap.readVal((ManagedAccessor)this.keyAccessor, k);
            Tag valueTag = SyncableMap.readVal((ManagedAccessor)this.valueAccessor, v);
            tag.put("k", keyTag);
            if (valueTag != null) {
                tag.put("v", valueTag);
            }
            list.add((Object)tag);
        });
        return list;
    }

    @Override
    public void deserializeNBT(Tag nbt) {
        this.map.clear();
        if (nbt instanceof CompoundTag) {
            CompoundTag tag2 = (CompoundTag)nbt;
            for (String key : tag2.getAllKeys()) {
                Tag valueTag = tag2.get(key);
                Object value = SyncableMap.writeVal((ManagedAccessor)this.valueAccessor, valueTag, this.valueType);
                this.map.put(key, value);
            }
            return;
        }
        ((ListTag)nbt).forEach(tag -> {
            CompoundTag compound = (CompoundTag)tag;
            Tag keyTag = compound.get("k");
            Tag valueTag = compound.get("v");
            Object key = SyncableMap.writeVal((ManagedAccessor)this.keyAccessor, keyTag, this.keyType);
            Object value = SyncableMap.writeVal((ManagedAccessor)this.valueAccessor, valueTag, this.valueType);
            this.map.put(key, value);
        });
    }

    @Override
    public void setOnContentsChanged(Runnable onContentsChanged) {
        this.onContentsChanged = onContentsChanged;
    }

    @Override
    public Runnable getOnContentsChanged() {
        return this.onContentsChanged;
    }
}

