/*
 * Decompiled with CFR 0.152.
 */
package com.lowdragmc.lowdraglib.networking.c2s;

import com.lowdragmc.lowdraglib.gui.modular.ModularUIContainer;
import com.lowdragmc.lowdraglib.networking.IHandlerContext;
import com.lowdragmc.lowdraglib.networking.IPacket;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.inventory.AbstractContainerMenu;

public class CPacketUIClientAction
implements IPacket {
    public int windowId;
    public FriendlyByteBuf updateData;

    public CPacketUIClientAction(int windowId, FriendlyByteBuf updateData) {
        this.windowId = windowId;
        this.updateData = updateData;
    }

    @Override
    public void encode(FriendlyByteBuf buf) {
        buf.writeVarInt(this.updateData.readableBytes());
        buf.writeBytes((ByteBuf)this.updateData);
        buf.writeVarInt(this.windowId);
    }

    @Override
    public void decode(FriendlyByteBuf buf) {
        ByteBuf directSliceBuffer = buf.readBytes(buf.readVarInt());
        ByteBuf copiedDataBuffer = Unpooled.copiedBuffer((ByteBuf)directSliceBuffer);
        directSliceBuffer.release();
        this.updateData = new FriendlyByteBuf(copiedDataBuffer);
        this.windowId = buf.readVarInt();
    }

    @Override
    public void execute(IHandlerContext handler) {
        AbstractContainerMenu openContainer;
        if (handler.getPlayer() != null && (openContainer = handler.getPlayer().containerMenu) instanceof ModularUIContainer) {
            ((ModularUIContainer)openContainer).handleClientAction(this);
        }
    }

    public CPacketUIClientAction() {
    }
}

