/*
 * Decompiled with CFR 0.152.
 */
package com.lowdragmc.lowdraglib.networking.s2c;

import com.lowdragmc.lowdraglib.LDLib;
import com.lowdragmc.lowdraglib.networking.IHandlerContext;
import com.lowdragmc.lowdraglib.networking.IPacket;
import com.lowdragmc.lowdraglib.networking.PacketIntLocation;
import com.lowdragmc.lowdraglib.syncdata.IManagedStorage;
import com.lowdragmc.lowdraglib.syncdata.TypedPayloadRegistries;
import com.lowdragmc.lowdraglib.syncdata.accessor.IManagedAccessor;
import com.lowdragmc.lowdraglib.syncdata.blockentity.IAutoSyncBlockEntity;
import com.lowdragmc.lowdraglib.syncdata.field.ManagedKey;
import com.lowdragmc.lowdraglib.syncdata.managed.IRef;
import com.lowdragmc.lowdraglib.syncdata.payload.ITypedPayload;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Objects;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.core.BlockPos;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.jetbrains.annotations.NotNull;

public class SPacketManagedPayload
extends PacketIntLocation
implements IPacket {
    private CompoundTag extra;
    private BlockEntityType<?> blockEntityType;
    private BitSet changed;
    private ITypedPayload<?>[] payloads;

    public SPacketManagedPayload(BlockEntityType<?> type, BlockPos pos, BitSet changed, ITypedPayload<?>[] payloads, CompoundTag extra) {
        super(pos);
        this.blockEntityType = type;
        this.changed = changed;
        this.payloads = payloads;
        this.extra = extra;
    }

    public SPacketManagedPayload(CompoundTag tag) {
        super(BlockPos.of((long)tag.getLong("p")));
        this.blockEntityType = (BlockEntityType)BuiltInRegistries.BLOCK_ENTITY_TYPE.get(new ResourceLocation(tag.getString("t")));
        this.changed = BitSet.valueOf(tag.getByteArray("c"));
        ListTag list = tag.getList("l", 10);
        this.payloads = new ITypedPayload[list.size()];
        for (int i = 0; i < this.payloads.length; ++i) {
            CompoundTag payloadTag = list.getCompound(i);
            byte id = payloadTag.getByte("t");
            ITypedPayload<?> payload = TypedPayloadRegistries.create(id);
            payload.deserializeNBT(payloadTag.get("d"));
            this.payloads[i] = payload;
        }
        this.extra = tag.getCompound("e");
    }

    public CompoundTag serializeNBT() {
        CompoundTag tag = new CompoundTag();
        tag.putLong("p", this.pos.asLong());
        tag.putString("t", Objects.requireNonNull(BuiltInRegistries.BLOCK_ENTITY_TYPE.getKey(this.blockEntityType)).toString());
        tag.putByteArray("c", this.changed.toByteArray());
        ListTag list = new ListTag();
        for (ITypedPayload<?> payload : this.payloads) {
            CompoundTag payloadTag = new CompoundTag();
            payloadTag.putByte("t", payload.getType());
            Tag data = payload.serializeNBT();
            if (data != null) {
                payloadTag.put("d", data);
            }
            list.add((Object)payloadTag);
        }
        tag.put("l", (Tag)list);
        tag.put("e", (Tag)this.extra);
        return tag;
    }

    public static SPacketManagedPayload of(IAutoSyncBlockEntity tile, boolean force) {
        BitSet changed = new BitSet();
        ArrayList payloads = new ArrayList();
        IRef[] syncedFields = tile.getRootStorage().getSyncFields();
        for (int i = 0; i < syncedFields.length; ++i) {
            IRef field = syncedFields[i];
            if (!force && !field.isSyncDirty()) continue;
            changed.set(i);
            ManagedKey key = field.getKey();
            payloads.add(key.readSyncedField(field, force));
            field.clearSyncDirty();
        }
        CompoundTag extra = new CompoundTag();
        tile.writeCustomSyncData(extra);
        return new SPacketManagedPayload(tile.getBlockEntityType(), tile.getCurrentPos(), changed, payloads.toArray(new ITypedPayload[0]), extra);
    }

    public void processPacket(@NotNull IAutoSyncBlockEntity blockEntity) {
        if (blockEntity.getSelf().getType() != this.blockEntityType) {
            LDLib.LOGGER.warn("Block entity type mismatch in managed payload packet!");
            return;
        }
        IManagedStorage storage = blockEntity.getRootStorage();
        IRef[] syncedFields = storage.getSyncFields();
        IManagedAccessor.writeSyncedFields(storage, syncedFields, this.changed, this.payloads);
        blockEntity.readCustomSyncData(this.extra);
    }

    @Override
    public void encode(FriendlyByteBuf buf) {
        super.encode(buf);
        buf.writeResourceLocation(Objects.requireNonNull(BuiltInRegistries.BLOCK_ENTITY_TYPE.getKey(this.blockEntityType)));
        buf.writeByteArray(this.changed.toByteArray());
        for (ITypedPayload<?> payload : this.payloads) {
            buf.writeByte((int)payload.getType());
            payload.writePayload(buf);
        }
        buf.writeNbt(this.extra);
    }

    @Override
    public void decode(FriendlyByteBuf buffer) {
        super.decode(buffer);
        this.blockEntityType = (BlockEntityType)BuiltInRegistries.BLOCK_ENTITY_TYPE.get(buffer.readResourceLocation());
        this.changed = BitSet.valueOf(buffer.readByteArray());
        this.payloads = new ITypedPayload[this.changed.cardinality()];
        for (int i = 0; i < this.payloads.length; ++i) {
            byte id = buffer.readByte();
            ITypedPayload<?> payload = TypedPayloadRegistries.create(id);
            payload.readPayload(buffer);
            this.payloads[i] = payload;
        }
        this.extra = buffer.readNbt();
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void execute(IHandlerContext handler) {
        BlockEntity blockEntity;
        ClientLevel level;
        if (handler.isClient() && (level = Minecraft.getInstance().level) != null && (blockEntity = level.getBlockEntity(this.pos)) instanceof IAutoSyncBlockEntity) {
            IAutoSyncBlockEntity autoSyncBlockEntity = (IAutoSyncBlockEntity)blockEntity;
            this.processPacket(autoSyncBlockEntity);
        }
    }

    public SPacketManagedPayload() {
    }
}

