/*
 * Decompiled with CFR 0.152.
 */
package com.lowdragmc.lowdraglib.rei;

import com.lowdragmc.lowdraglib.gui.ingredient.Target;
import com.lowdragmc.lowdraglib.gui.modular.ModularUIGuiContainer;
import dev.architectury.event.CompoundEventResult;
import java.util.List;
import java.util.stream.Stream;
import me.shedaniel.math.Rectangle;
import me.shedaniel.rei.api.client.gui.drag.DraggableStack;
import me.shedaniel.rei.api.client.gui.drag.DraggableStackVisitor;
import me.shedaniel.rei.api.client.gui.drag.DraggedAcceptorResult;
import me.shedaniel.rei.api.client.gui.drag.DraggingContext;
import me.shedaniel.rei.api.client.registry.screen.ExclusionZonesProvider;
import me.shedaniel.rei.api.client.registry.screen.FocusedStackProvider;
import me.shedaniel.rei.api.common.entry.EntryIngredient;
import me.shedaniel.rei.api.common.entry.EntryStack;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.renderer.Rect2i;

public final class ModularUIReiHandlers {
    public static final ExclusionZonesProvider<ModularUIGuiContainer> EXCLUSION_ZONES_PROVIDER = screen -> screen.getGuiExtraAreas().stream().map(rect2 -> new Rectangle(rect2.getX(), rect2.getY(), rect2.getWidth(), rect2.getHeight())).toList();
    public static final FocusedStackProvider FOCUSED_STACK_PROVIDER = (screen, mouse) -> {
        if (screen instanceof ModularUIGuiContainer) {
            EntryIngredient entryStacks;
            ModularUIGuiContainer containerScreen = (ModularUIGuiContainer)screen;
            Object target = containerScreen.modularUI.mainGroup.getXEIIngredientOverMouse(mouse.getX(), mouse.getY());
            if (target instanceof EntryStack) {
                EntryStack entryStack = (EntryStack)target;
                return CompoundEventResult.interruptTrue((Object)entryStack);
            }
            if (target instanceof EntryIngredient && (entryStacks = (EntryIngredient)target).size() > 0) {
                return CompoundEventResult.interruptTrue((Object)((EntryStack)entryStacks.get(0)));
            }
        }
        return CompoundEventResult.pass();
    };
    public static final DraggableStackVisitor<ModularUIGuiContainer> DRAGGABLE_STACK_VISITOR = new DraggableStackVisitor<ModularUIGuiContainer>(){

        public <R extends Screen> boolean isHandingScreen(R screen) {
            return screen instanceof ModularUIGuiContainer;
        }

        public DraggedAcceptorResult acceptDraggedStack(DraggingContext<ModularUIGuiContainer> context, DraggableStack stack) {
            List<Target> targets = ((ModularUIGuiContainer)context.getScreen()).modularUI.mainGroup.getPhantomTargets(stack.get().getValue());
            if (targets.isEmpty()) {
                return DraggedAcceptorResult.PASS;
            }
            for (Target target : targets) {
                Rect2i area = target.getArea();
                Rectangle rect = new Rectangle(area.getX(), area.getY(), area.getWidth(), area.getHeight());
                if (!rect.contains(context.getCurrentPosition())) continue;
                target.accept(stack.get().getValue());
                return DraggedAcceptorResult.ACCEPTED;
            }
            return DraggedAcceptorResult.PASS;
        }

        public Stream<DraggableStackVisitor.BoundsProvider> getDraggableAcceptingBounds(DraggingContext<ModularUIGuiContainer> context, DraggableStack stack) {
            List<Target> targets = ((ModularUIGuiContainer)context.getScreen()).modularUI.mainGroup.getPhantomTargets(stack.get().getValue());
            if (targets.isEmpty()) {
                return Stream.empty();
            }
            return targets.stream().map(Target::getArea).map(area -> DraggableStackVisitor.BoundsProvider.ofRectangle((Rectangle)new Rectangle(area.getX(), area.getY(), area.getWidth(), area.getHeight())));
        }
    };
}

