/*
 * Decompiled with CFR 0.152.
 */
package com.lowdragmc.lowdraglib.side.fluid;

import com.lowdragmc.lowdraglib.side.fluid.FluidHelper;
import java.util.Objects;
import javax.annotation.Nonnull;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;

public class FluidStack {
    private static final FluidStack EMPTY = new FluidStack(Fluids.EMPTY, 0L, null);
    private boolean isEmpty;
    private long amount;
    private CompoundTag tag;
    private Fluid fluid;

    public static FluidStack empty() {
        return EMPTY;
    }

    public static FluidStack create(Fluid fluid, long amount, CompoundTag nbt) {
        return new FluidStack(fluid, amount, nbt);
    }

    public static FluidStack create(Fluid fluid, long amount) {
        return FluidStack.create(fluid, amount, null);
    }

    public static FluidStack create(FluidStack stack, long amount) {
        return FluidStack.create(stack.getFluid(), amount, stack.getTag());
    }

    private FluidStack(Fluid fluid, long amount, CompoundTag nbt) {
        this.fluid = fluid;
        this.amount = amount;
        if (nbt != null) {
            this.tag = nbt.copy();
        }
        this.updateEmpty();
    }

    public static FluidStack loadFromTag(CompoundTag nbt) {
        if (nbt == null) {
            return EMPTY;
        }
        if (!nbt.contains("FluidName", 8)) {
            return EMPTY;
        }
        ResourceLocation fluidName = new ResourceLocation(nbt.getString("FluidName"));
        Fluid fluid = (Fluid)BuiltInRegistries.FLUID.get(fluidName);
        if (fluid == Fluids.EMPTY) {
            return EMPTY;
        }
        FluidStack stack = FluidStack.create(fluid, nbt.getLong("Amount"));
        if (nbt.contains("Tag", 10)) {
            stack.setTag(nbt.getCompound("Tag"));
        }
        return stack;
    }

    public static FluidStack readFromBuf(FriendlyByteBuf buf) {
        Fluid fluid = (Fluid)BuiltInRegistries.FLUID.get(new ResourceLocation(buf.readUtf()));
        int amount = buf.readVarInt();
        CompoundTag tag = buf.readNbt();
        if (fluid == Fluids.EMPTY) {
            return EMPTY;
        }
        return FluidStack.create(fluid, amount, tag);
    }

    protected void updateEmpty() {
        this.isEmpty = this.getRawFluid() == Fluids.EMPTY || this.amount <= 0L;
    }

    public CompoundTag saveToTag(CompoundTag nbt) {
        nbt.putString("FluidName", BuiltInRegistries.FLUID.getKey((Object)this.fluid).toString());
        nbt.putLong("Amount", this.amount);
        if (this.tag != null) {
            nbt.put("Tag", (Tag)this.tag);
        }
        return nbt;
    }

    public void writeToBuf(FriendlyByteBuf buf) {
        buf.writeUtf(BuiltInRegistries.FLUID.getKey((Object)this.fluid).toString());
        buf.writeVarLong(this.getAmount());
        buf.writeNbt(this.tag);
    }

    public Fluid getFluid() {
        return this.isEmpty ? Fluids.EMPTY : this.fluid;
    }

    public final Fluid getRawFluid() {
        return this.fluid;
    }

    public long getAmount() {
        return this.isEmpty ? 0L : this.amount;
    }

    public void setAmount(long amount) {
        if (this.fluid == Fluids.EMPTY) {
            throw new IllegalStateException("Can't modify the empty stack.");
        }
        this.amount = amount;
        this.updateEmpty();
    }

    public boolean hasTag() {
        return this.tag != null;
    }

    public CompoundTag getTag() {
        return this.tag;
    }

    public void setTag(CompoundTag tag) {
        if (this.getRawFluid() == Fluids.EMPTY) {
            throw new IllegalStateException("Can't modify the empty stack.");
        }
        this.tag = tag;
    }

    public boolean isEmpty() {
        return this.getAmount() == 0L || this == FluidStack.empty();
    }

    public Component getDisplayName() {
        return FluidHelper.getDisplayName(this);
    }

    public FluidStack copy() {
        return FluidStack.create(this.getFluid(), this.getAmount(), this.getTag() == null ? null : this.getTag().copy());
    }

    public FluidStack copy(long amount) {
        return FluidStack.create(this.getFluid(), amount, this.getTag());
    }

    public boolean isFluidEqual(@Nonnull FluidStack other) {
        return this.getFluid() == other.getFluid() && Objects.equals(this.getTag(), other.getTag());
    }

    public boolean isFluidStackEqual(@Nonnull FluidStack other) {
        return this.isFluidEqual(other) && this.getAmount() == other.getAmount();
    }

    public void grow(long amount) {
        this.setAmount(this.getAmount() + amount);
    }

    public void shrink(long amount) {
        this.setAmount(this.getAmount() - amount);
    }

    public void setFluid(Fluid fluid) {
        this.fluid = fluid;
    }
}

