/*
 * Decompiled with CFR 0.152.
 */
package com.lowdragmc.lowdraglib.side.item;

import javax.annotation.Nonnull;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

public interface IItemTransfer {
    public static final IItemTransfer EMPTY = new IItemTransfer(){

        @Override
        public int getSlots() {
            return 0;
        }

        @Override
        @NotNull
        public ItemStack getStackInSlot(int slot) {
            return ItemStack.EMPTY;
        }

        @Override
        @NotNull
        public ItemStack insertItem(int slot, @NotNull ItemStack stack, boolean simulate, boolean notifyChanges) {
            return stack;
        }

        @Override
        @NotNull
        public ItemStack extractItem(int slot, int amount, boolean simulate, boolean notifyChanges) {
            return ItemStack.EMPTY;
        }

        @Override
        public int getSlotLimit(int slot) {
            return 0;
        }

        @Override
        public boolean isItemValid(int slot, @NotNull ItemStack stack) {
            return false;
        }

        @Override
        @NotNull
        public Object createSnapshot() {
            return new Object();
        }

        @Override
        public void restoreFromSnapshot(Object snapshot) {
        }
    };

    public int getSlots();

    @Nonnull
    public ItemStack getStackInSlot(int var1);

    default public void setStackInSlot(int index, ItemStack stack) {
        this.extractItem(index, this.getStackInSlot(index).getCount(), false, false);
        this.insertItem(index, stack, false, false);
    }

    @Nonnull
    public ItemStack insertItem(int var1, @Nonnull ItemStack var2, boolean var3, boolean var4);

    default public ItemStack insertItem(int slot, @Nonnull ItemStack stack, boolean simulate) {
        return this.insertItem(slot, stack, simulate, !simulate);
    }

    @Nonnull
    public ItemStack extractItem(int var1, int var2, boolean var3, boolean var4);

    default public ItemStack extractItem(int slot, int amount, boolean simulate) {
        return this.extractItem(slot, amount, simulate, !simulate);
    }

    public int getSlotLimit(int var1);

    public boolean isItemValid(int var1, @Nonnull ItemStack var2);

    default public void onContentsChanged() {
    }

    @Nonnull
    @ApiStatus.Internal
    public Object createSnapshot();

    @ApiStatus.Internal
    public void restoreFromSnapshot(Object var1);
}

