/*
 * Decompiled with CFR 0.152.
 */
package com.lowdragmc.lowdraglib.side.item;

import com.lowdragmc.lowdraglib.misc.PlayerInventoryTransfer;
import com.lowdragmc.lowdraglib.side.item.IItemTransfer;
import com.lowdragmc.lowdraglib.side.item.forge.ItemTransferHelperImpl;
import dev.architectury.injectables.annotations.ExpectPlatform;
import java.util.function.Predicate;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;

public class ItemTransferHelper {
    /*
     * WARNING - void declaration
     */
    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static IItemTransfer getItemTransfer(Level level, BlockPos pos, @Nullable Direction direction) {
        void var2_2;
        void var1_1;
        return ItemTransferHelperImpl.getItemTransfer(level, (BlockPos)var1_1, (Direction)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static void exportToTarget(IItemTransfer source, int maxAmount, Predicate<ItemStack> predicate, Level level, BlockPos pos, @Nullable Direction direction) {
        void var5_5;
        void var4_4;
        void var3_3;
        void var2_2;
        void var1_1;
        ItemTransferHelperImpl.exportToTarget(source, (int)var1_1, (Predicate<ItemStack>)var2_2, (Level)var3_3, (BlockPos)var4_4, (Direction)var5_5);
    }

    /*
     * WARNING - void declaration
     */
    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static void importToTarget(IItemTransfer target, int maxAmount, Predicate<ItemStack> predicate, Level level, BlockPos pos, @Nullable Direction direction) {
        void var5_5;
        void var4_4;
        void var3_3;
        void var2_2;
        void var1_1;
        ItemTransferHelperImpl.importToTarget(target, (int)var1_1, (Predicate<ItemStack>)var2_2, (Level)var3_3, (BlockPos)var4_4, (Direction)var5_5);
    }

    public static boolean canItemStacksStack(ItemStack first, ItemStack second) {
        if (!first.isEmpty() && ItemStack.isSameItem((ItemStack)first, (ItemStack)second) && first.hasTag() == second.hasTag()) {
            return !first.hasTag() || first.getTag().equals((Object)second.getTag());
        }
        return false;
    }

    public static ItemStack copyStackWithSize(ItemStack stack, int size) {
        if (size == 0) {
            return ItemStack.EMPTY;
        }
        ItemStack copy = stack.copy();
        copy.setCount(size);
        return copy;
    }

    @Nonnull
    public static ItemStack insertItem(IItemTransfer dest, @Nonnull ItemStack stack, boolean simulate) {
        if (dest == null || stack.isEmpty()) {
            return stack;
        }
        for (int i = 0; i < dest.getSlots(); ++i) {
            if (!(stack = dest.insertItem(i, stack, simulate)).isEmpty()) continue;
            return ItemStack.EMPTY;
        }
        return stack;
    }

    @Nonnull
    public static ItemStack insertItemStacked(IItemTransfer inventory, ItemStack stack, boolean simulate) {
        ItemStack slot;
        int i;
        if (inventory == null || stack.isEmpty()) {
            return stack;
        }
        if (!stack.isStackable()) {
            return ItemTransferHelper.insertItem(inventory, stack, simulate);
        }
        int sizeInventory = inventory.getSlots();
        for (i = 0; !(i >= sizeInventory || ItemTransferHelper.canItemStacksStackRelaxed(slot = inventory.getStackInSlot(i), stack) && (stack = inventory.insertItem(i, stack, simulate)).isEmpty()); ++i) {
        }
        if (!stack.isEmpty()) {
            for (i = 0; !(i >= sizeInventory || inventory.getStackInSlot(i).isEmpty() && (stack = inventory.insertItem(i, stack, simulate)).isEmpty()); ++i) {
            }
        }
        return stack;
    }

    public static boolean canItemStacksStackRelaxed(@Nonnull ItemStack a, @Nonnull ItemStack b) {
        if (a.isEmpty() || b.isEmpty() || a.getItem() != b.getItem()) {
            return false;
        }
        if (!a.isStackable()) {
            return false;
        }
        if (a.hasTag() != b.hasTag()) {
            return false;
        }
        return !a.hasTag() || a.getTag().equals((Object)b.getTag());
    }

    public static void giveItemToPlayer(Player player, ItemStack stack) {
        ItemTransferHelper.giveItemToPlayer(player, stack, -1);
    }

    public static void giveItemToPlayer(Player player, @Nonnull ItemStack stack, int preferredSlot) {
        if (stack.isEmpty()) {
            return;
        }
        PlayerInventoryTransfer inventory = new PlayerInventoryTransfer(player.getInventory());
        Level level = player.level();
        ItemStack remainder = stack;
        if (preferredSlot >= 0 && preferredSlot < inventory.getSlots()) {
            remainder = inventory.insertItem(preferredSlot, stack, false);
        }
        if (!remainder.isEmpty()) {
            remainder = ItemTransferHelper.insertItemStacked(inventory, remainder, false);
        }
        if (remainder.isEmpty() || remainder.getCount() != stack.getCount()) {
            level.playSound(null, player.getX(), player.getY() + 0.5, player.getZ(), SoundEvents.ITEM_PICKUP, SoundSource.PLAYERS, 0.2f, ((level.random.nextFloat() - level.random.nextFloat()) * 0.7f + 1.0f) * 2.0f);
        }
        if (!remainder.isEmpty() && !level.isClientSide) {
            ItemEntity entityitem = new ItemEntity(level, player.getX(), player.getY() + 0.5, player.getZ(), remainder);
            entityitem.setPickUpDelay(40);
            entityitem.setDeltaMovement(entityitem.getDeltaMovement().multiply(0.0, 1.0, 0.0));
            level.addFreshEntity((Entity)entityitem);
        }
    }
}

