/*
 * Decompiled with CFR 0.152.
 */
package com.lowdragmc.lowdraglib.syncdata.accessor;

import com.lowdragmc.lowdraglib.gui.editor.data.resource.Resource;
import com.lowdragmc.lowdraglib.gui.texture.IGuiTexture;
import com.lowdragmc.lowdraglib.gui.texture.UIResourceTexture;
import com.lowdragmc.lowdraglib.syncdata.AccessorOp;
import com.lowdragmc.lowdraglib.syncdata.accessor.CustomObjectAccessor;
import com.lowdragmc.lowdraglib.syncdata.payload.ITypedPayload;
import com.lowdragmc.lowdraglib.syncdata.payload.NbtTagPayload;
import com.mojang.datafixers.util.Either;
import java.io.File;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;

public class IGuiTextureAccessor
extends CustomObjectAccessor<IGuiTexture> {
    public IGuiTextureAccessor() {
        super(IGuiTexture.class, true);
    }

    @Override
    public ITypedPayload<?> serialize(AccessorOp op, IGuiTexture value) {
        CompoundTag tag = IGuiTexture.serializeWrapper(value);
        if (tag == null) {
            tag = new CompoundTag();
            if (value instanceof UIResourceTexture) {
                UIResourceTexture uiResourceTexture = (UIResourceTexture)value;
                tag.putString("type", "ui_resource");
                tag.put("key", (Tag)uiResourceTexture.key.map(l -> {
                    CompoundTag key = new CompoundTag();
                    key.putString("key", l);
                    key.putString("type", "builtin");
                    return key;
                }, r -> {
                    CompoundTag key = new CompoundTag();
                    key.putString("key", r.getPath());
                    key.putString("type", "project");
                    return key;
                }));
            } else {
                tag.putString("type", "empty");
            }
        }
        return NbtTagPayload.of((Tag)tag);
    }

    @Override
    public IGuiTexture deserialize(AccessorOp op, ITypedPayload<?> payload) {
        if (payload instanceof NbtTagPayload) {
            NbtTagPayload nbtTagPayload = (NbtTagPayload)payload;
            CompoundTag tag = (CompoundTag)nbtTagPayload.getPayload();
            String type = tag.getString("type");
            if (type.equals("ui_resource") && tag.contains("key")) {
                Tag keyTag = tag.get("key");
                Either key = null;
                if (keyTag instanceof CompoundTag) {
                    CompoundTag compoundTag = (CompoundTag)keyTag;
                    String keyType = compoundTag.getString("type");
                    String keyValue = compoundTag.getString("key");
                    if (keyType.equals("builtin")) {
                        key = Either.left((Object)keyValue);
                    } else if (keyType.equals("project")) {
                        key = Either.right((Object)new File(keyValue));
                    }
                } else if (keyTag != null) {
                    key = Either.left((Object)keyTag.getAsString());
                }
                Resource<IGuiTexture> resource = UIResourceTexture.getProjectResource();
                if (resource == null) {
                    return new UIResourceTexture((Either<String, File>)key);
                }
                if (UIResourceTexture.isProject()) {
                    return new UIResourceTexture(resource, (Either<String, File>)key);
                }
                return key == null ? IGuiTexture.MISSING_TEXTURE : resource.getResourceOrDefault((Either<String, File>)key, IGuiTexture.MISSING_TEXTURE);
            }
            return IGuiTexture.deserializeWrapper(tag);
        }
        return null;
    }
}

