/*
 * Decompiled with CFR 0.152.
 */
package com.lowdragmc.lowdraglib.syncdata.accessor;

import com.lowdragmc.lowdraglib.client.renderer.IRenderer;
import com.lowdragmc.lowdraglib.client.renderer.ISerializableRenderer;
import com.lowdragmc.lowdraglib.client.renderer.impl.UIResourceRenderer;
import com.lowdragmc.lowdraglib.gui.editor.data.resource.Resource;
import com.lowdragmc.lowdraglib.syncdata.AccessorOp;
import com.lowdragmc.lowdraglib.syncdata.accessor.CustomObjectAccessor;
import com.lowdragmc.lowdraglib.syncdata.payload.ITypedPayload;
import com.lowdragmc.lowdraglib.syncdata.payload.NbtTagPayload;
import com.mojang.datafixers.util.Either;
import java.io.File;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;

public class IRendererAccessor
extends CustomObjectAccessor<IRenderer> {
    public IRendererAccessor() {
        super(IRenderer.class, true);
    }

    @Override
    public ITypedPayload<?> serialize(AccessorOp op, IRenderer value) {
        if (value instanceof ISerializableRenderer) {
            ISerializableRenderer serializableRenderer = (ISerializableRenderer)value;
            return NbtTagPayload.of((Tag)ISerializableRenderer.serializeWrapper(serializableRenderer));
        }
        if (value instanceof UIResourceRenderer) {
            UIResourceRenderer renderer = (UIResourceRenderer)value;
            CompoundTag tag = new CompoundTag();
            tag.putString("_type", "ui_resource");
            tag.put("key", (Tag)renderer.key.map(l -> {
                CompoundTag key = new CompoundTag();
                key.putString("key", l);
                key.putString("type", "builtin");
                return key;
            }, r -> {
                CompoundTag key = new CompoundTag();
                key.putString("key", r.getPath());
                key.putString("type", "project");
                return key;
            }));
            return NbtTagPayload.of((Tag)tag);
        }
        return NbtTagPayload.of((Tag)new CompoundTag());
    }

    @Override
    public IRenderer deserialize(AccessorOp op, ITypedPayload<?> payload) {
        NbtTagPayload nbtTagPayload;
        Object t;
        if (payload instanceof NbtTagPayload && (t = (nbtTagPayload = (NbtTagPayload)payload).getPayload()) instanceof CompoundTag) {
            CompoundTag tag = (CompoundTag)t;
            if (tag.contains("_type") && tag.getString("_type").equals("ui_resource")) {
                Tag keyTag = tag.get("key");
                Either key = null;
                if (keyTag instanceof CompoundTag) {
                    CompoundTag compoundTag = (CompoundTag)keyTag;
                    String keyType = compoundTag.getString("type");
                    String keyValue = compoundTag.getString("key");
                    if (keyType.equals("builtin")) {
                        key = Either.left((Object)keyValue);
                    } else if (keyType.equals("project")) {
                        key = Either.right((Object)new File(keyValue));
                    }
                } else if (keyTag != null) {
                    key = Either.left((Object)keyTag.getAsString());
                }
                Resource<IRenderer> resource = UIResourceRenderer.getProjectResource();
                if (resource == null) {
                    return new UIResourceRenderer((Either<String, File>)key);
                }
                if (UIResourceRenderer.isProject()) {
                    return new UIResourceRenderer(resource, (Either<String, File>)key);
                }
                return key == null ? IRenderer.EMPTY : resource.getResourceOrDefault((Either<String, File>)key, IRenderer.EMPTY);
            }
            ISerializableRenderer renderer = ISerializableRenderer.deserializeWrapper(tag);
            if (renderer != null) {
                return renderer;
            }
        }
        return IRenderer.EMPTY;
    }
}

