/*
 * Decompiled with CFR 0.152.
 */
package com.lowdragmc.lowdraglib.syncdata.accessor;

import com.lowdragmc.lowdraglib.syncdata.AccessorOp;
import com.lowdragmc.lowdraglib.syncdata.accessor.CustomObjectAccessor;
import com.lowdragmc.lowdraglib.syncdata.payload.ITypedPayload;
import com.lowdragmc.lowdraglib.syncdata.payload.NbtTagPayload;
import com.lowdragmc.lowdraglib.utils.Range;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;

public class RangeAccessor
extends CustomObjectAccessor<Range> {
    public RangeAccessor() {
        super(Range.class, true);
    }

    @Override
    public ITypedPayload<?> serialize(AccessorOp op, Range value) {
        CompoundTag tag = new CompoundTag();
        if (value.getA() instanceof Float || value.getA() instanceof Double) {
            tag.putFloat("a", value.getA().floatValue());
        } else {
            tag.putInt("a", value.getA().intValue());
        }
        if (value.getB() instanceof Float || value.getB() instanceof Double) {
            tag.putFloat("b", value.getB().floatValue());
        } else {
            tag.putInt("b", value.getB().intValue());
        }
        return NbtTagPayload.of((Tag)tag);
    }

    @Override
    public Range deserialize(AccessorOp op, ITypedPayload<?> payload) {
        NbtTagPayload nbtTagPayload;
        Object t;
        if (payload instanceof NbtTagPayload && (t = (nbtTagPayload = (NbtTagPayload)payload).getPayload()) instanceof CompoundTag) {
            CompoundTag tag = (CompoundTag)t;
            Number a = tag.contains("a", 3) ? (Number)tag.getInt("a") : (Number)Float.valueOf(tag.getFloat("a"));
            Number b = tag.contains("b", 3) ? (Number)tag.getInt("b") : (Number)Float.valueOf(tag.getFloat("b"));
            return new Range(a, b);
        }
        return null;
    }
}

