/*
 * Decompiled with CFR 0.152.
 */
package com.lowdragmc.lowdraglib.syncdata.accessor;

import com.lowdragmc.lowdraglib.syncdata.AccessorOp;
import com.lowdragmc.lowdraglib.syncdata.IAccessor;
import com.lowdragmc.lowdraglib.syncdata.TypedPayloadRegistries;
import com.lowdragmc.lowdraglib.syncdata.managed.IRef;
import com.lowdragmc.lowdraglib.syncdata.managed.ReadOnlyManagedField;
import com.lowdragmc.lowdraglib.syncdata.managed.ReadOnlyManagedRef;
import com.lowdragmc.lowdraglib.syncdata.payload.ITypedPayload;
import com.lowdragmc.lowdraglib.syncdata.payload.NbtTagPayload;
import com.lowdragmc.lowdraglib.syncdata.payload.PrimitiveTypedPayload;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;

public abstract class ReadonlyAccessor
implements IAccessor {
    private byte defaultType = (byte)-1;

    @Override
    public byte getDefaultType() {
        return this.defaultType;
    }

    @Override
    public void setDefaultType(byte defaultType) {
        this.defaultType = defaultType;
    }

    @Override
    public abstract ITypedPayload<?> readFromReadonlyField(AccessorOp var1, Object var2);

    @Override
    public abstract void writeToReadonlyField(AccessorOp var1, Object var2, ITypedPayload<?> var3);

    @Override
    public boolean isManaged() {
        return false;
    }

    @Override
    public ITypedPayload<?> readField(AccessorOp op, IRef field) {
        Object obj = field.readRaw();
        if (field instanceof ReadOnlyManagedRef) {
            ReadOnlyManagedRef managedRef = (ReadOnlyManagedRef)field;
            if (obj == null) {
                return PrimitiveTypedPayload.NullPayload.ofNull();
            }
            CompoundTag tag = new CompoundTag();
            tag.put("uid", (Tag)managedRef.getReadOnlyField().serializeUid(obj));
            CompoundTag payloadTag = new CompoundTag();
            ITypedPayload<?> payload = this.readFromReadonlyField(op, obj);
            payloadTag.putByte("t", payload.getType());
            Tag data = payload.serializeNBT();
            if (data != null) {
                payloadTag.put("d", data);
            }
            tag.put("payload", (Tag)payloadTag);
            return NbtTagPayload.of((Tag)tag);
        }
        if (obj == null) {
            throw new IllegalArgumentException("readonly field %s has a null reference".formatted(field.getKey()));
        }
        return this.readFromReadonlyField(op, obj);
    }

    @Override
    public void writeField(AccessorOp op, IRef field, ITypedPayload<?> payload) {
        Object obj = field.readRaw();
        if (field instanceof ReadOnlyManagedRef) {
            NbtTagPayload nbtTagPayload;
            Object t;
            PrimitiveTypedPayload primitive;
            ReadOnlyManagedRef managedRef = (ReadOnlyManagedRef)field;
            ReadOnlyManagedField readOnlyField = managedRef.getReadOnlyField();
            if (payload instanceof PrimitiveTypedPayload && (primitive = (PrimitiveTypedPayload)payload).isNull()) {
                readOnlyField.set(null);
            } else if (payload instanceof NbtTagPayload && (t = (nbtTagPayload = (NbtTagPayload)payload).getPayload()) instanceof CompoundTag) {
                CompoundTag tag = (CompoundTag)t;
                CompoundTag uid = tag.getCompound("uid");
                if (obj == null || !readOnlyField.serializeUid(obj).equals((Object)uid)) {
                    obj = managedRef.getReadOnlyField().deserializeUid(uid);
                    readOnlyField.set(obj);
                }
                CompoundTag payloadTag = tag.getCompound("payload");
                byte id = payloadTag.getByte("t");
                ITypedPayload<?> p = TypedPayloadRegistries.create(id);
                p.deserializeNBT(payloadTag.get("d"));
                this.writeToReadonlyField(op, obj, p);
            }
            return;
        }
        if (obj == null) {
            throw new IllegalArgumentException("readonly field %s has a null reference".formatted(field));
        }
        this.writeToReadonlyField(op, obj, payload);
    }
}

