/*
 * Decompiled with CFR 0.152.
 */
package com.lowdragmc.lowdraglib.syncdata.accessor;

import com.lowdragmc.lowdraglib.LDLib;
import com.lowdragmc.lowdraglib.Platform;
import com.lowdragmc.lowdraglib.syncdata.AccessorOp;
import com.lowdragmc.lowdraglib.syncdata.accessor.CustomObjectAccessor;
import com.lowdragmc.lowdraglib.syncdata.payload.ITypedPayload;
import com.lowdragmc.lowdraglib.syncdata.payload.NbtTagPayload;
import net.minecraft.client.Minecraft;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeManager;
import net.minecraft.world.item.crafting.RecipeType;

public class RecipeAccessor
extends CustomObjectAccessor<Recipe> {
    public RecipeAccessor() {
        super(Recipe.class, true);
    }

    @Override
    public ITypedPayload<?> serialize(AccessorOp op, Recipe value) {
        ResourceLocation type = BuiltInRegistries.RECIPE_TYPE.getKey((Object)value.getType());
        ResourceLocation id = value.getId();
        CompoundTag tag = new CompoundTag();
        tag.putString("type", type == null ? "null" : type.toString());
        tag.putString("id", id.toString());
        return NbtTagPayload.of((Tag)tag);
    }

    @Override
    public Recipe deserialize(AccessorOp op, ITypedPayload<?> payload) {
        NbtTagPayload nbtTagPayload;
        Object t;
        if (payload instanceof NbtTagPayload && (t = (nbtTagPayload = (NbtTagPayload)payload).getPayload()) instanceof CompoundTag) {
            CompoundTag tag = (CompoundTag)t;
            RecipeType type = (RecipeType)BuiltInRegistries.RECIPE_TYPE.get(new ResourceLocation(tag.getString("type")));
            ResourceLocation id = new ResourceLocation(tag.getString("id"));
            if (type != null) {
                RecipeManager recipeManager = LDLib.isRemote() ? Minecraft.getInstance().getConnection().getRecipeManager() : Platform.getMinecraftServer().getRecipeManager();
                for (Recipe recipe : recipeManager.getRecipes()) {
                    if (recipe.getType() != type || !recipe.getId().equals((Object)id)) continue;
                    return recipe;
                }
            }
        }
        return null;
    }
}

