/*
 * Decompiled with CFR 0.152.
 */
package com.lowdragmc.lowdraglib.syncdata.blockentity;

import com.lowdragmc.lowdraglib.Platform;
import com.lowdragmc.lowdraglib.async.AsyncThreadData;
import com.lowdragmc.lowdraglib.async.IAsyncLogic;
import com.lowdragmc.lowdraglib.networking.LDLNetworking;
import com.lowdragmc.lowdraglib.networking.s2c.SPacketManagedPayload;
import com.lowdragmc.lowdraglib.syncdata.blockentity.IAutoSyncBlockEntity;
import com.lowdragmc.lowdraglib.syncdata.managed.IRef;
import java.util.Objects;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.ApiStatus;

public interface IAsyncAutoSyncBlockEntity
extends IAutoSyncBlockEntity,
IAsyncLogic {
    default public boolean useAsyncThread() {
        return true;
    }

    default public void onValid() {
        Level level;
        if (this.useAsyncThread() && (level = this.getSelf().getLevel()) instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            AsyncThreadData.getOrCreate(serverLevel).addAsyncLogic(this);
        }
    }

    default public void onInValid() {
        Level level = this.getSelf().getLevel();
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            AsyncThreadData.getOrCreate(serverLevel).removeAsyncLogic(this);
        }
    }

    @ApiStatus.AvailableSince(value="1.21")
    default public boolean isAsyncSyncing() {
        return false;
    }

    @ApiStatus.AvailableSince(value="1.21")
    default public void setAsyncSyncing(boolean syncing) {
    }

    @Override
    default public void asyncTick(long periodID) {
        if (Platform.isServerNotSafe()) {
            return;
        }
        if (this.useAsyncThread() && !this.getSelf().isRemoved()) {
            for (IRef field : this.getNonLazyFields()) {
                field.update();
            }
            if (this.getRootStorage().hasDirtySyncFields() && !this.isAsyncSyncing()) {
                this.setAsyncSyncing(true);
                Platform.getMinecraftServer().execute(() -> {
                    if (Platform.isServerNotSafe()) {
                        return;
                    }
                    SPacketManagedPayload packet = SPacketManagedPayload.of(this, false);
                    LDLNetworking.NETWORK.sendToTrackingChunk(packet, Objects.requireNonNull(this.getSelf().getLevel()).getChunkAt(this.getCurrentPos()));
                    this.setAsyncSyncing(false);
                });
            }
        }
    }
}

