/*
 * Decompiled with CFR 0.152.
 */
package com.lowdragmc.lowdraglib.syncdata.field;

import com.lowdragmc.lowdraglib.LDLib;
import com.lowdragmc.lowdraglib.syncdata.IEnhancedManaged;
import com.lowdragmc.lowdraglib.syncdata.IFieldUpdateListener;
import com.lowdragmc.lowdraglib.syncdata.IManaged;
import com.lowdragmc.lowdraglib.syncdata.IManagedStorage;
import com.lowdragmc.lowdraglib.syncdata.ISubscription;
import com.lowdragmc.lowdraglib.syncdata.ManagedFieldUtils;
import com.lowdragmc.lowdraglib.syncdata.annotation.RequireRerender;
import com.lowdragmc.lowdraglib.syncdata.annotation.UpdateListener;
import com.lowdragmc.lowdraglib.syncdata.field.FieldUpdateSubscription;
import com.lowdragmc.lowdraglib.syncdata.field.ManagedKey;
import com.lowdragmc.lowdraglib.syncdata.managed.IRef;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.locks.ReentrantLock;
import java.util.function.BiFunction;
import net.minecraft.Util;

public class FieldManagedStorage
implements IManagedStorage {
    private final IManaged owner;
    private BitSet dirtySyncFields;
    private BitSet dirtyPersistedFields;
    private IRef[] syncFields;
    private boolean initialized = false;
    private IRef[] persistedFields;
    private IRef[] nonLazyFields;
    private Map<ManagedKey, IRef> fieldMap;
    private final ReentrantLock lock = new ReentrantLock();
    private final Map<ManagedKey, List<FieldUpdateSubscription>> listeners = new HashMap<ManagedKey, List<FieldUpdateSubscription>>();
    static final BiFunction<Field, Class<?>, Method> METHOD_CACHES = Util.memoize((rawField, clazz) -> {
        String methodName = rawField.getAnnotation(UpdateListener.class).methodName();
        Method method = null;
        while (clazz != null && method == null) {
            try {
                method = clazz.getDeclaredMethod(methodName, rawField.getType(), rawField.getType());
                method.setAccessible(true);
            }
            catch (NoSuchMethodException noSuchMethodException) {
                // empty catch block
            }
            clazz = clazz.getSuperclass();
        }
        if (method == null) {
            LDLib.LOGGER.error("couldn't find the listener method {} for synced field {}", (Object)methodName, (Object)rawField.getName());
        }
        return method;
    });

    @Override
    public <T> ISubscription addSyncUpdateListener(ManagedKey key, IFieldUpdateListener<T> listener) {
        FieldUpdateSubscription subscription = new FieldUpdateSubscription(key, listener){

            @Override
            public void unsubscribe() {
                ((List)FieldManagedStorage.this.listeners.getOrDefault(this.key, new ArrayList())).remove(this);
            }
        };
        this.listeners.computeIfAbsent(key, k -> new ArrayList()).add(subscription);
        return subscription;
    }

    @Override
    public void removeAllSyncUpdateListener(ManagedKey key) {
        this.listeners.remove(key);
    }

    @Override
    public boolean hasSyncListener(ManagedKey key) {
        List<FieldUpdateSubscription> list = this.listeners.get(key);
        return list != null && !list.isEmpty();
    }

    @Override
    public <T> void notifyFieldUpdate(ManagedKey key, T newVal, T oldVal) {
        List<FieldUpdateSubscription> list = this.listeners.get(key);
        if (list != null) {
            for (FieldUpdateSubscription sub : list) {
                IFieldUpdateListener<?> listener = sub.listener;
                try {
                    listener.onFieldChanged(key.getName(), newVal, oldVal);
                }
                catch (Throwable t) {
                    t.printStackTrace();
                }
            }
        }
    }

    @Override
    public void init() {
        this.lock.lock();
        try {
            if (this.initialized) {
                return;
            }
            ManagedKey[] fields = this.owner.getFieldHolder().getFields();
            ManagedFieldUtils.FieldRefs result = ManagedFieldUtils.getFieldRefs(fields, this.owner, (ref, index, changed) -> {
                if (this.dirtySyncFields != null && index >= 0) {
                    this.dirtySyncFields.set(index, changed);
                    this.owner.onSyncChanged(ref, changed);
                }
            }, (ref, index, changed) -> {
                if (this.dirtyPersistedFields != null && index >= 0) {
                    this.dirtyPersistedFields.set(index, changed);
                    this.owner.onPersistedChanged(ref, changed);
                }
            });
            this.syncFields = result.syncedRefs();
            this.persistedFields = result.persistedRefs();
            this.dirtySyncFields = new BitSet(this.syncFields.length);
            this.dirtyPersistedFields = new BitSet(result.persistedRefs().length);
            this.nonLazyFields = result.nonLazyFields();
            this.fieldMap = result.fieldRefMap();
            this.initialized = true;
            if (LDLib.isClient()) {
                this.initEnhancedFeature();
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    public FieldManagedStorage(IManaged owner) {
        this.owner = owner;
    }

    @Override
    public IRef[] getSyncFields() {
        this.init();
        return this.syncFields;
    }

    @Override
    public boolean hasDirtySyncFields() {
        return !this.dirtySyncFields.isEmpty();
    }

    @Override
    public boolean hasDirtyPersistedFields() {
        return !this.dirtyPersistedFields.isEmpty();
    }

    @Override
    public IRef[] getPersistedFields() {
        this.init();
        return this.persistedFields;
    }

    @Override
    public IManaged[] getManaged() {
        return new IManaged[]{this.owner};
    }

    @Override
    public IRef getFieldByKey(ManagedKey key) {
        this.init();
        return this.fieldMap.get(key);
    }

    @Override
    public IRef[] getNonLazyFields() {
        this.init();
        return this.nonLazyFields;
    }

    public void initEnhancedFeature() {
        for (IRef syncField : this.getSyncFields()) {
            Method method;
            IManaged iManaged;
            Field rawField = syncField.getKey().getRawField();
            if (rawField.isAnnotationPresent(RequireRerender.class) && (iManaged = this.owner) instanceof IEnhancedManaged) {
                IEnhancedManaged enhancedManaged = (IEnhancedManaged)iManaged;
                this.addSyncUpdateListener(syncField.getKey(), enhancedManaged::scheduleRender);
            }
            if (!rawField.isAnnotationPresent(UpdateListener.class) || (method = METHOD_CACHES.apply(rawField, this.owner.getClass())) == null) continue;
            this.addSyncUpdateListener(syncField.getKey(), (name, newValue, oldValue) -> {
                try {
                    method.invoke((Object)this.owner, newValue, oldValue);
                }
                catch (IllegalAccessException | InvocationTargetException e) {
                    throw new RuntimeException(e);
                }
            });
        }
    }
}

