/*
 * Decompiled with CFR 0.152.
 */
package com.lowdragmc.lowdraglib.syncdata.managed;

import com.lowdragmc.lowdraglib.syncdata.IFieldUpdateListener;
import com.lowdragmc.lowdraglib.syncdata.IManaged;
import com.lowdragmc.lowdraglib.syncdata.IManagedStorage;
import com.lowdragmc.lowdraglib.syncdata.ISubscription;
import com.lowdragmc.lowdraglib.syncdata.field.ManagedKey;
import com.lowdragmc.lowdraglib.syncdata.managed.IRef;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class MultiManagedStorage
implements IManagedStorage {
    private final List<IManagedStorage> storages = new ArrayList<IManagedStorage>();
    private final Map<ManagedKey, IRef> cacheFields = new HashMap<ManagedKey, IRef>();
    private IManaged[] cacheManaged = null;
    private IRef[] cacheNonLazyFields = null;
    private IRef[] cachePersistedFields = null;
    private IRef[] cacheSyncFields = null;

    public void attach(IManagedStorage storage) {
        this.clearCache();
        this.storages.add(storage);
    }

    public void detach(IManagedStorage storage) {
        this.clearCache();
        this.storages.remove(storage);
    }

    public void clearCache() {
        this.cacheFields.clear();
        this.cacheManaged = null;
        this.cacheNonLazyFields = null;
        this.cachePersistedFields = null;
        this.cacheSyncFields = null;
    }

    @Override
    public IRef getFieldByKey(ManagedKey key) {
        if (!this.cacheFields.containsKey(key)) {
            IManagedStorage storage;
            IRef ref = null;
            Iterator<IManagedStorage> iterator = this.storages.iterator();
            while (iterator.hasNext() && (ref = (storage = iterator.next()).getFieldByKey(key)) == null) {
            }
            this.cacheFields.put(key, ref);
        }
        return this.cacheFields.get(key);
    }

    @Override
    public IManaged[] getManaged() {
        if (this.cacheManaged == null) {
            this.cacheManaged = (IManaged[])this.storages.stream().map(IManagedStorage::getManaged).flatMap(Arrays::stream).toArray(IManaged[]::new);
        }
        return this.cacheManaged;
    }

    @Override
    public IRef[] getNonLazyFields() {
        if (this.cacheNonLazyFields == null) {
            this.cacheNonLazyFields = (IRef[])this.storages.stream().map(IManagedStorage::getNonLazyFields).flatMap(Arrays::stream).toArray(IRef[]::new);
        }
        return this.cacheNonLazyFields;
    }

    @Override
    public IRef[] getPersistedFields() {
        if (this.cachePersistedFields == null) {
            this.cachePersistedFields = (IRef[])this.storages.stream().map(IManagedStorage::getPersistedFields).flatMap(Arrays::stream).toArray(IRef[]::new);
        }
        return this.cachePersistedFields;
    }

    @Override
    public IRef[] getSyncFields() {
        if (this.cacheSyncFields == null) {
            this.cacheSyncFields = (IRef[])this.storages.stream().map(IManagedStorage::getSyncFields).flatMap(Arrays::stream).toArray(IRef[]::new);
        }
        return this.cacheSyncFields;
    }

    @Override
    public boolean hasDirtySyncFields() {
        for (IManagedStorage storage : this.storages) {
            if (!storage.hasDirtySyncFields()) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean hasDirtyPersistedFields() {
        for (IManagedStorage storage : this.storages) {
            if (!storage.hasDirtyPersistedFields()) continue;
            return true;
        }
        return false;
    }

    @Override
    public <T> ISubscription addSyncUpdateListener(ManagedKey key, IFieldUpdateListener<T> listener) {
        throw new IllegalStateException("do not add listener for multi managed storage");
    }

    @Override
    public void removeAllSyncUpdateListener(ManagedKey key) {
        throw new IllegalStateException("do not remove listener for multi managed storage");
    }

    @Override
    public boolean hasSyncListener(ManagedKey key) {
        for (IManagedStorage storage : this.storages) {
            if (!storage.hasSyncListener(key)) continue;
            return true;
        }
        return false;
    }

    @Override
    public <T> void notifyFieldUpdate(ManagedKey key, T newVal, T oldVal) {
        for (IManagedStorage storage : this.storages) {
            storage.notifyFieldUpdate(key, newVal, oldVal);
        }
    }

    @Override
    public void init() {
        this.storages.forEach(IManagedStorage::init);
    }
}

