/*
 * Decompiled with CFR 0.152.
 */
package com.lowdragmc.lowdraglib.syncdata.payload;

import com.lowdragmc.lowdraglib.syncdata.TypedPayloadRegistries;
import com.lowdragmc.lowdraglib.syncdata.payload.ITypedPayload;
import com.lowdragmc.lowdraglib.syncdata.payload.ObjectTypedPayload;
import javax.annotation.Nullable;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;

public class ArrayPayload
extends ObjectTypedPayload<ITypedPayload<?>[]> {
    public static ArrayPayload of(ITypedPayload<?>[] payload) {
        return (ArrayPayload)new ArrayPayload().setPayload(payload);
    }

    @Override
    @Nullable
    public Tag serializeNBT() {
        ListTag list = new ListTag();
        for (ITypedPayload payload : (ITypedPayload[])this.getPayload()) {
            CompoundTag compound = new CompoundTag();
            compound.putByte("t", payload.getType());
            Tag nbt = payload.serializeNBT();
            if (nbt != null) {
                compound.put("p", nbt);
            }
            list.add((Object)compound);
        }
        return list;
    }

    @Override
    public void deserializeNBT(Tag input) {
        if (!(input instanceof ListTag)) {
            throw new IllegalArgumentException("Tag %s is not ListTag".formatted(input));
        }
        ListTag list = (ListTag)input;
        this.payload = new ITypedPayload[list.size()];
        for (int i = 0; i < list.size(); ++i) {
            Tag t = list.get(i);
            if (!(t instanceof CompoundTag)) {
                throw new IllegalArgumentException("Tag %s is not CompoundTag".formatted(t));
            }
            CompoundTag compound = (CompoundTag)t;
            byte type = compound.getByte("t");
            Tag tag = compound.get("p");
            ((ITypedPayload[])this.payload)[i] = TypedPayloadRegistries.create(type);
            ((ITypedPayload[])this.payload)[i].deserializeNBT(tag);
        }
    }

    @Override
    public void writePayload(FriendlyByteBuf buf) {
        buf.writeVarInt(((ITypedPayload[])this.payload).length);
        for (ITypedPayload payload : (ITypedPayload[])this.payload) {
            buf.writeByte((int)payload.getType());
            payload.writePayload(buf);
        }
    }

    @Override
    public void readPayload(FriendlyByteBuf buf) {
        this.payload = new ITypedPayload[buf.readVarInt()];
        for (int i = 0; i < ((ITypedPayload[])this.payload).length; ++i) {
            byte type = buf.readByte();
            ((ITypedPayload[])this.payload)[i] = TypedPayloadRegistries.create(type);
            ((ITypedPayload[])this.payload)[i].readPayload(buf);
        }
    }
}

