/*
 * Decompiled with CFR 0.152.
 */
package com.lowdragmc.lowdraglib.syncdata.payload;

import com.lowdragmc.lowdraglib.syncdata.TypedPayloadRegistries;
import com.lowdragmc.lowdraglib.syncdata.payload.ITypedPayload;
import java.util.Objects;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;

public abstract class ObjectTypedPayload<T>
implements ITypedPayload<T> {
    protected T payload;

    protected ObjectTypedPayload() {
    }

    public ITypedPayload<T> setPayload(T payload) {
        this.payload = payload;
        return this;
    }

    @Override
    public byte getType() {
        return TypedPayloadRegistries.getId(this.getClass());
    }

    @Override
    public T getPayload() {
        return this.payload;
    }

    @Override
    public boolean isPrimitive() {
        return false;
    }

    @Override
    public void writePayload(FriendlyByteBuf buf) {
        Tag nbt = this.serializeNBT();
        if (nbt instanceof CompoundTag) {
            buf.writeBoolean(true);
            buf.writeNbt((CompoundTag)nbt);
        } else {
            buf.writeBoolean(false);
            CompoundTag root = new CompoundTag();
            if (nbt != null) {
                root.put("d", nbt);
            }
            buf.writeNbt(root);
        }
    }

    @Override
    public void readPayload(FriendlyByteBuf buf) {
        if (buf.readBoolean()) {
            CompoundTag nbt = buf.readNbt();
            this.deserializeNBT((Tag)nbt);
        } else {
            CompoundTag root = buf.readNbt();
            Objects.requireNonNull(root);
            Tag nbt = root.get("d");
            this.deserializeNBT(nbt);
        }
    }
}

