/*
 * Decompiled with CFR 0.152.
 */
package com.lowdragmc.lowdraglib.test.ui;

import com.lowdragmc.lowdraglib.gui.modular.IUIHolder;
import com.lowdragmc.lowdraglib.gui.modular.ModularUI;
import com.lowdragmc.lowdraglib.gui.widget.SceneWidget;
import com.lowdragmc.lowdraglib.utils.Size;
import java.util.Collection;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public interface IUITest {
    @Nullable
    default public Size getSize() {
        return null;
    }

    @OnlyIn(value=Dist.CLIENT)
    default public int getScreenWidth() {
        return Minecraft.getInstance().getWindow().getGuiScaledWidth();
    }

    @OnlyIn(value=Dist.CLIENT)
    default public int getScreenHeight() {
        return Minecraft.getInstance().getWindow().getGuiScaledHeight();
    }

    default public ModularUI createUI(IUIHolder holder, Player entityPlayer) {
        Size size = this.getSize();
        if (size != null) {
            return new ModularUI(size, holder, entityPlayer);
        }
        return new ModularUI(holder, entityPlayer);
    }

    default public SceneWidget createRealWorldScene(@Nullable Size size, @Nullable Collection<BlockPos> positions) {
        if (size == null) {
            size = new Size(Minecraft.getInstance().getWindow().getGuiScaledWidth(), Minecraft.getInstance().getWindow().getGuiScaledHeight());
        }
        SceneWidget sceneWidget = new SceneWidget(0, 0, size.width, size.height, (Level)Minecraft.getInstance().level);
        sceneWidget.useCacheBuffer();
        if (positions == null) {
            BlockPos playerPos = Minecraft.getInstance().player.getOnPos();
            sceneWidget.setRenderedCore(List.of(playerPos, playerPos.above(), playerPos.below(), playerPos.east(), playerPos.west(), playerPos.north(), playerPos.south()));
        } else {
            sceneWidget.setRenderedCore(positions);
        }
        return sceneWidget;
    }
}

