/*
 * Decompiled with CFR 0.152.
 */
package com.lowdragmc.lowdraglib.utils;

import com.google.common.base.Suppliers;
import com.lowdragmc.lowdraglib.LDLib;
import com.lowdragmc.lowdraglib.client.scene.ParticleManager;
import com.lowdragmc.lowdraglib.core.mixins.accessor.ParticleEngineAccessor;
import com.lowdragmc.lowdraglib.utils.DummyChunkSource;
import com.lowdragmc.lowdraglib.utils.virtual.WrappedClientWorld;
import java.lang.ref.WeakReference;
import java.util.Collections;
import java.util.List;
import java.util.UUID;
import java.util.function.Consumer;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.Particle;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.AbortableIterationConsumer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.flag.FeatureFlagSet;
import net.minecraft.world.item.crafting.RecipeManager;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LightLayer;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.biome.BiomeManager;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.ChunkSource;
import net.minecraft.world.level.chunk.LightChunkGetter;
import net.minecraft.world.level.entity.EntityTypeTest;
import net.minecraft.world.level.entity.LevelEntityGetter;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.lighting.LevelLightEngine;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.level.saveddata.maps.MapItemSavedData;
import net.minecraft.world.level.storage.WritableLevelData;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.scores.Scoreboard;
import net.minecraft.world.ticks.LevelTickAccess;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ParametersAreNonnullByDefault
@MethodsReturnNonnullByDefault
public class DummyWorld
extends Level {
    protected DummyChunkSource chunkProvider = new DummyChunkSource(this);
    private final BiomeManager biomeManager;
    public WeakReference<Level> level;
    protected final LevelLightEngine lighter;
    private final BlockPos.MutableBlockPos scratch = new BlockPos.MutableBlockPos();
    private Supplier<ClientLevel> asClientWorld = Suppliers.memoize(() -> WrappedClientWorld.of(this));
    @OnlyIn(value=Dist.CLIENT)
    private ParticleManager particleManager;

    public DummyWorld(Level level) {
        super((WritableLevelData)level.getLevelData(), level.dimension(), level.registryAccess(), level.dimensionTypeRegistration(), () -> ((Level)level).getProfiler(), true, false, 0L, 0);
        this.level = new WeakReference<Level>(level);
        this.lighter = new LevelLightEngine((LightChunkGetter)this.chunkProvider, true, false);
        this.biomeManager = new BiomeManager((BiomeManager.NoiseBiomeSource)this, 0L);
    }

    @NotNull
    public Level getLevel() {
        Level level = (Level)this.level.get();
        if (level == null) {
            level = Minecraft.getInstance().level;
            this.level = new WeakReference<Level>(level);
        }
        assert (level != null);
        return level;
    }

    public boolean setBlock(BlockPos pPos, BlockState pState, int pFlags, int pRecursionLeft) {
        return false;
    }

    public void setBlockEntity(BlockEntity pBlockEntity) {
    }

    public BlockState getBlockState(BlockPos pPos) {
        return Blocks.AIR.defaultBlockState();
    }

    public void playSound(@Nullable Player pPlayer, double pX, double pY, double pZ, SoundEvent pSound, SoundSource pCategory, float pVolume, float pPitch) {
    }

    public void playSound(@Nullable Player pPlayer, Entity pEntity, SoundEvent pEvent, SoundSource pCategory, float pVolume, float pPitch) {
    }

    public String gatherChunkSourceStats() {
        return "";
    }

    @Nullable
    public BlockEntity getBlockEntity(BlockPos pPos) {
        return null;
    }

    public float getShade(Direction direction, boolean b) {
        return switch (direction) {
            default -> throw new IncompatibleClassChangeError();
            case Direction.DOWN, Direction.UP -> 0.9f;
            case Direction.NORTH, Direction.SOUTH -> 0.8f;
            case Direction.WEST, Direction.EAST -> 0.6f;
        };
    }

    public LevelLightEngine getLightEngine() {
        if (LDLib.isClient()) {
            return Minecraft.getInstance().level.getLightEngine();
        }
        return null;
    }

    public Holder<Biome> getBiome(BlockPos pPos) {
        return super.getBiome(pPos.offset(Vec3i.ZERO));
    }

    public int getBrightness(LightLayer pLightType, BlockPos pBlockPos) {
        return 15;
    }

    public int getRawBrightness(@Nonnull BlockPos pos, int p_226659_2_) {
        return 15;
    }

    public boolean canSeeSky(@Nonnull BlockPos pos) {
        return true;
    }

    public void sendBlockUpdated(BlockPos pos, BlockState oldState, BlockState newState, int flags) {
    }

    public Holder<Biome> getUncachedNoiseBiome(int pX, int pY, int pZ) {
        return this.getLevel().getUncachedNoiseBiome(pX, pY, pZ);
    }

    public Holder<Biome> getNoiseBiome(int pX, int pY, int pZ) {
        return this.getLevel().getNoiseBiome(pX, pY, pZ);
    }

    public BiomeManager getBiomeManager() {
        return this.biomeManager;
    }

    public RegistryAccess registryAccess() {
        return this.getLevel().registryAccess();
    }

    public FeatureFlagSet enabledFeatures() {
        return this.getLevel().enabledFeatures();
    }

    public LevelTickAccess<Block> getBlockTicks() {
        return this.getLevel().getBlockTicks();
    }

    public LevelTickAccess<Fluid> getFluidTicks() {
        return this.getLevel().getFluidTicks();
    }

    public RecipeManager getRecipeManager() {
        return this.getLevel().getRecipeManager();
    }

    public int getFreeMapId() {
        return this.getLevel().getFreeMapId();
    }

    public Scoreboard getScoreboard() {
        return this.getLevel().getScoreboard();
    }

    public Entity getEntity(int id) {
        return null;
    }

    public MapItemSavedData getMapData(String mapName) {
        return null;
    }

    public void setMapData(String pMapId, MapItemSavedData pData) {
    }

    public void destroyBlockProgress(int breakerId, BlockPos pos, int progress) {
    }

    protected LevelEntityGetter<Entity> getEntities() {
        return new LevelEntityGetter<Entity>(){

            @Nullable
            public Entity get(int id) {
                return null;
            }

            @Nullable
            public Entity get(UUID uuid) {
                return null;
            }

            public Iterable<Entity> getAll() {
                return Collections.emptyList();
            }

            public <U extends Entity> void get(EntityTypeTest<Entity, U> test, AbortableIterationConsumer<U> consumer) {
            }

            public void get(AABB boundingBox, Consumer<Entity> consumer) {
            }

            public <U extends Entity> void get(EntityTypeTest<Entity, U> test, AABB bounds, AbortableIterationConsumer<U> consumer) {
            }
        };
    }

    public boolean isLoaded(BlockPos p_195588_1_) {
        return true;
    }

    public ChunkSource getChunkSource() {
        return this.chunkProvider;
    }

    public void levelEvent(@Nullable Player pPlayer, int pType, BlockPos pPos, int pData) {
    }

    public void gameEvent(GameEvent event, Vec3 position, GameEvent.Context context) {
    }

    public void gameEvent(@Nullable Entity pEntity, GameEvent pEvent, BlockPos pPos) {
    }

    public List<? extends Player> players() {
        return Collections.emptyList();
    }

    public FluidState getFluidState(BlockPos pPos) {
        return Fluids.EMPTY.defaultFluidState();
    }

    public void playSeededSound(@Nullable Player player, double x, double y, double z, Holder<SoundEvent> sound, SoundSource source, float volume, float pitch, long seed) {
    }

    public void playSeededSound(@Nullable Player player, double x, double y, double z, SoundEvent soundEvent, SoundSource soundSource, float volume, float pitch, long seed) {
    }

    public void playSeededSound(@Nullable Player player, Entity entity, Holder<SoundEvent> sound, SoundSource category, float volume, float pitch, long seed) {
    }

    public void addParticle(ParticleOptions particleData, double x, double y, double z, double xSpeed, double ySpeed, double zSpeed) {
        Particle p;
        if (this.particleManager != null && (p = ((ParticleEngineAccessor)Minecraft.getInstance().particleEngine).invokeMakeParticle(particleData, x, y, z, xSpeed, ySpeed, zSpeed)) != null) {
            this.particleManager.addParticle(p);
        }
    }

    public void addParticle(ParticleOptions particleData, boolean forceAlwaysRender, double x, double y, double z, double xSpeed, double ySpeed, double zSpeed) {
        this.addParticle(particleData, x, y, z, xSpeed, ySpeed, zSpeed);
    }

    public void addAlwaysVisibleParticle(ParticleOptions particleData, double x, double y, double z, double xSpeed, double ySpeed, double zSpeed) {
        this.addParticle(particleData, x, y, z, xSpeed, ySpeed, zSpeed);
    }

    public void addAlwaysVisibleParticle(ParticleOptions particleData, boolean ignoreRange, double x, double y, double z, double xSpeed, double ySpeed, double zSpeed) {
        this.addParticle(particleData, ignoreRange, x, y, z, xSpeed, ySpeed, zSpeed);
    }

    public BlockState getBlockState(int x, int y, int z) {
        return this.getBlockState((BlockPos)this.scratch.set(x, y, z));
    }

    public Supplier<ClientLevel> getAsClientWorld() {
        return this.asClientWorld;
    }

    public ParticleManager getParticleManager() {
        return this.particleManager;
    }

    public void setParticleManager(ParticleManager particleManager) {
        this.particleManager = particleManager;
    }
}

