/*
 * Decompiled with CFR 0.152.
 */
package com.lowdragmc.lowdraglib.utils;

import com.lowdragmc.lowdraglib.LDLib;
import com.lowdragmc.lowdraglib.gui.editor.data.resource.Resource;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.client.resources.language.I18n;

public class LocalizationUtils {
    public static Resource<String> RESOURCE;
    private static final Map<String, String> DYNAMIC_LANG;

    public static void setResource(Resource<String> resource) {
        RESOURCE = resource;
    }

    public static void clearResource() {
        RESOURCE = null;
    }

    public static void appendDynamicLang(Map<String, String> dynamicLang) {
        DYNAMIC_LANG.putAll(dynamicLang);
    }

    public static boolean hasDynamicLang(String key) {
        return DYNAMIC_LANG.containsKey(key);
    }

    public static String getDynamicLang(String key) {
        return DYNAMIC_LANG.get(key);
    }

    public static String format(String localisationKey, Object ... substitutions) {
        if (!LDLib.isClient()) {
            return String.format(localisationKey, substitutions);
        }
        if (RESOURCE != null && RESOURCE.hasBuiltinResource(localisationKey)) {
            return RESOURCE.getBuiltinResource(localisationKey);
        }
        return I18n.get((String)localisationKey, (Object[])substitutions);
    }

    public static boolean exist(String localisationKey) {
        if (LDLib.isClient()) {
            return I18n.exists((String)localisationKey);
        }
        return false;
    }

    static {
        DYNAMIC_LANG = new HashMap<String, String>();
    }
}

