/*
 * Decompiled with CFR 0.152.
 */
package com.lowdragmc.lowdraglib.utils;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonPrimitive;
import java.util.Set;
import net.minecraft.nbt.ByteArrayTag;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.IntArrayTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.LongArrayTag;
import net.minecraft.nbt.NumericTag;
import net.minecraft.nbt.StringTag;
import net.minecraft.nbt.Tag;

public class NBTToJsonConverter {
    public static JsonElement getObject(Tag tag) {
        JsonObject jsonRoot;
        if (tag instanceof CompoundTag) {
            CompoundTag compoundTag = (CompoundTag)tag;
            Set keys = compoundTag.getAllKeys();
            jsonRoot = new JsonObject();
            for (String key : keys) {
                Tag nbt = compoundTag.get(key);
                jsonRoot.add(key, NBTToJsonConverter.getObject(nbt));
            }
        } else if (tag instanceof NumericTag) {
            NumericTag numericTag = (NumericTag)tag;
            jsonRoot = new JsonPrimitive(numericTag.getAsNumber());
        } else if (tag instanceof StringTag) {
            jsonRoot = new JsonPrimitive(tag.getAsString());
        } else if (tag instanceof ListTag) {
            ListTag tagList = (ListTag)tag;
            JsonArray array = new JsonArray();
            for (Tag value : tagList) {
                array.add(NBTToJsonConverter.getObject(value));
            }
            jsonRoot = array;
        } else if (tag instanceof IntArrayTag) {
            IntArrayTag intArray = (IntArrayTag)tag;
            JsonArray array = new JsonArray();
            for (int i : intArray.getAsIntArray()) {
                array.add((JsonElement)new JsonPrimitive((Number)i));
            }
            jsonRoot = array;
        } else if (tag instanceof ByteArrayTag) {
            ByteArrayTag intArray = (ByteArrayTag)tag;
            JsonArray array = new JsonArray();
            for (byte i : intArray.getAsByteArray()) {
                array.add((JsonElement)new JsonPrimitive((Number)i));
            }
            jsonRoot = array;
        } else if (tag instanceof LongArrayTag) {
            LongArrayTag intArray = (LongArrayTag)tag;
            JsonArray array = new JsonArray();
            for (long i : intArray.getAsLongArray()) {
                array.add((JsonElement)new JsonPrimitive((Number)i));
            }
            jsonRoot = array;
        } else {
            throw new JsonParseException("NBT to JSON converter doesn't support the nbt tag: " + tag.getId() + ", tag: " + String.valueOf(tag));
        }
        return jsonRoot;
    }
}

