/*
 * Decompiled with CFR 0.152.
 */
package com.lowdragmc.lowdraglib.utils;

import com.lowdragmc.lowdraglib.LDLib;
import java.net.URL;
import javax.annotation.Nonnull;
import net.minecraft.client.Minecraft;
import net.minecraft.resources.ResourceLocation;

public class ResourceHelper {
    public static boolean isResourceExistRaw(ResourceLocation rs) {
        URL url = ResourceHelper.class.getResource(String.format("/assets/%s/%s", rs.getNamespace(), rs.getPath()));
        return url != null;
    }

    public static boolean isResourceExist(ResourceLocation rs) {
        if (LDLib.isClient()) {
            return Minecraft.getInstance().getResourceManager().getResource(rs).isPresent();
        }
        return false;
    }

    public static boolean isTextureExist(@Nonnull ResourceLocation location) {
        ResourceLocation textureLocation = new ResourceLocation(location.getNamespace(), "textures/%s.png".formatted(location.getPath()));
        return ResourceHelper.isResourceExist(textureLocation) || ResourceHelper.isResourceExistRaw(textureLocation);
    }

    public static boolean isModelExist(@Nonnull ResourceLocation location) {
        ResourceLocation modelLocation = new ResourceLocation(location.getNamespace(), "models/%s.json".formatted(location.getPath()));
        return ResourceHelper.isResourceExist(modelLocation) || ResourceHelper.isResourceExistRaw(modelLocation);
    }
}

