/*
 * Decompiled with CFR 0.152.
 */
package com.lowdragmc.lowdraglib.utils.curve;

import com.lowdragmc.lowdraglib.syncdata.ITagSerializable;
import com.lowdragmc.lowdraglib.utils.Interpolations;
import com.lowdragmc.lowdraglib.utils.curve.Curve;
import net.minecraft.nbt.FloatTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.world.phys.Vec2;

public class ExplicitCubicBezierCurve2
extends Curve<Vec2>
implements ITagSerializable<ListTag> {
    public Vec2 p0;
    public Vec2 c0;
    public Vec2 c1;
    public Vec2 p1;

    public ExplicitCubicBezierCurve2(Vec2 start, Vec2 control1, Vec2 control2, Vec2 end) {
        this.p0 = start;
        this.c0 = control1;
        this.c1 = control2;
        this.p1 = end;
    }

    public ExplicitCubicBezierCurve2(ListTag list) {
        this.deserializeNBT(list);
    }

    @Override
    public Vec2 getPoint(float t) {
        if (this.c0.x == this.p0.x) {
            return new Vec2(this.p0.x + t * (this.p1.x - this.p0.x), this.c0.y > this.p0.y ? this.p0.y : this.p1.y);
        }
        if (this.c1.x == this.p1.x) {
            return new Vec2(this.p0.x + t * (this.p1.x - this.p0.x), this.c1.y > this.p1.y ? this.p1.y : this.p0.y);
        }
        return new Vec2(this.p0.x + t * (this.p1.x - this.p0.x), (float)Interpolations.CubicBezier(t, this.p0.y, this.c0.y, this.c1.y, this.p1.y));
    }

    @Override
    public ListTag serializeNBT() {
        ListTag list = new ListTag();
        list.add((Object)FloatTag.valueOf((float)this.p0.x));
        list.add((Object)FloatTag.valueOf((float)this.p0.y));
        list.add((Object)FloatTag.valueOf((float)this.c0.x));
        list.add((Object)FloatTag.valueOf((float)this.c0.y));
        list.add((Object)FloatTag.valueOf((float)this.c1.x));
        list.add((Object)FloatTag.valueOf((float)this.c1.y));
        list.add((Object)FloatTag.valueOf((float)this.p1.x));
        list.add((Object)FloatTag.valueOf((float)this.p1.y));
        return list;
    }

    @Override
    public void deserializeNBT(ListTag list) {
        this.p0 = new Vec2(list.getFloat(0), list.getFloat(1));
        this.c0 = new Vec2(list.getFloat(2), list.getFloat(3));
        this.c1 = new Vec2(list.getFloat(4), list.getFloat(5));
        this.p1 = new Vec2(list.getFloat(6), list.getFloat(7));
    }
}

