/*
 * Decompiled with CFR 0.152.
 */
package com.lowdragmc.lowdraglib.utils.virtual;

import com.lowdragmc.lowdraglib.utils.DummyWorld;
import com.lowdragmc.lowdraglib.utils.virtual.VirtualChunkSection;
import it.unimi.dsi.fastutil.longs.LongSet;
import it.unimi.dsi.fastutil.longs.LongSets;
import it.unimi.dsi.fastutil.shorts.ShortList;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.ChunkAccess;
import net.minecraft.world.level.chunk.ChunkStatus;
import net.minecraft.world.level.chunk.LevelChunk;
import net.minecraft.world.level.chunk.LevelChunkSection;
import net.minecraft.world.level.chunk.UpgradeData;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.levelgen.structure.Structure;
import net.minecraft.world.level.levelgen.structure.StructureStart;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.ticks.BlackholeTickAccess;
import net.minecraft.world.ticks.TickContainerAccess;

@ParametersAreNonnullByDefault
@MethodsReturnNonnullByDefault
public class VirtualChunk
extends LevelChunk {
    final DummyWorld world;
    boolean needsLight;
    final int x;
    final int z;
    private final LevelChunkSection[] sections;

    public VirtualChunk(DummyWorld world, int x, int z) {
        super((Level)world, new ChunkPos(x, z));
        this.world = world;
        this.needsLight = true;
        this.x = x;
        this.z = z;
        int sectionCount = world.getSectionsCount();
        this.sections = new LevelChunkSection[sectionCount];
        for (int i = 0; i < sectionCount; ++i) {
            this.sections[i] = new VirtualChunkSection(this, i << 4);
        }
    }

    public LevelChunkSection[] getSections() {
        return this.sections;
    }

    public ChunkStatus getStatus() {
        return ChunkStatus.LIGHT;
    }

    @Nullable
    public BlockState setBlockState(BlockPos p_177436_1_, BlockState p_177436_2_, boolean p_177436_3_) {
        return null;
    }

    public void setBlockEntity(BlockEntity p_177426_2_) {
    }

    public void addEntity(Entity p_76612_1_) {
    }

    public Set<BlockPos> getBlockEntitiesPos() {
        return Set.of();
    }

    public Collection<Map.Entry<Heightmap.Types, Heightmap>> getHeightmaps() {
        return Collections.emptyList();
    }

    public void setHeightmap(Heightmap.Types p_201607_1_, long[] p_201607_2_) {
    }

    public Heightmap getOrCreateHeightmapUnprimed(Heightmap.Types p_217303_1_) {
        return null;
    }

    public void setUnsaved(boolean p_177427_1_) {
    }

    public boolean isUnsaved() {
        return false;
    }

    public void removeBlockEntity(BlockPos pos) {
        this.world.removeBlockEntity(pos);
    }

    public ShortList[] getPostProcessing() {
        return new ShortList[0];
    }

    @Nullable
    public CompoundTag getBlockEntityNbt(BlockPos p_201579_1_) {
        return null;
    }

    @Nullable
    public CompoundTag getBlockEntityNbtForSaving(BlockPos p_223134_1_) {
        return null;
    }

    public UpgradeData getUpgradeData() {
        return null;
    }

    public void setInhabitedTime(long p_177415_1_) {
    }

    public long getInhabitedTime() {
        return 0L;
    }

    public boolean isLightCorrect() {
        return this.needsLight;
    }

    public void setLightCorrect(boolean needsLight) {
        this.needsLight = needsLight;
    }

    @Nullable
    public BlockEntity getBlockEntity(BlockPos pos) {
        return this.world.getBlockEntity(pos);
    }

    public BlockState getBlockState(BlockPos pos) {
        return this.world.getBlockState(pos);
    }

    public FluidState getFluidState(BlockPos p_204610_1_) {
        return Fluids.EMPTY.defaultFluidState();
    }

    @Nullable
    public StructureStart getStartForStructure(Structure structure) {
        return null;
    }

    public void setStartForStructure(Structure structure, StructureStart start) {
    }

    public Map<Structure, StructureStart> getAllStarts() {
        return Collections.emptyMap();
    }

    public void setAllStarts(Map<Structure, StructureStart> structureStarts) {
    }

    public LongSet getReferencesForStructure(Structure structure) {
        return LongSets.emptySet();
    }

    public void addReferenceForStructure(Structure structure, long reference) {
    }

    public Map<Structure, LongSet> getAllReferences() {
        return Collections.emptyMap();
    }

    public void setAllReferences(Map<Structure, LongSet> structureReferences) {
    }

    public int getMinBuildHeight() {
        return this.world.getMinBuildHeight();
    }

    public TickContainerAccess<Fluid> getFluidTicks() {
        return BlackholeTickAccess.emptyContainer();
    }

    public ChunkAccess.TicksToSave getTicksForSerialization() {
        return null;
    }

    public TickContainerAccess<Block> getBlockTicks() {
        return BlackholeTickAccess.emptyContainer();
    }
}

