/*
 * Decompiled with CFR 0.152.
 */
package com.lowdragmc.lowdraglib.utils.virtual;

import com.lowdragmc.lowdraglib.utils.virtual.VirtualChunk;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.core.registries.Registries;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.LevelChunkSection;

@ParametersAreNonnullByDefault
@MethodsReturnNonnullByDefault
public class VirtualChunkSection
extends LevelChunkSection {
    public VirtualChunk owner;
    public final int xStart;
    public final int yStart;
    public final int zStart;

    public VirtualChunkSection(VirtualChunk owner, int yBase) {
        super(owner.world.registryAccess().registryOrThrow(Registries.BIOME));
        this.owner = owner;
        this.xStart = owner.getPos().getMinBlockX();
        this.yStart = yBase;
        this.zStart = owner.getPos().getMinBlockZ();
    }

    public BlockState getBlockState(int x, int y, int z) {
        return this.owner.world.getBlockState(x + this.xStart, y + this.yStart, z + this.zStart);
    }

    public BlockState setBlockState(int p_177484_1_, int p_177484_2_, int p_177484_3_, BlockState p_177484_4_, boolean p_177484_5_) {
        throw new IllegalStateException("Chunk sections should not be mutated in a fake world.");
    }
}

