package com.lowdragmc.lowdraglib;

import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;

import com.lowdragmc.lowdraglib.gui.factory.UIEditorFactory;
import com.mojang.brigadier.arguments.BoolArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;

import net.minecraft.ChatFormatting;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.arguments.EntityArgument;
import net.minecraft.commands.arguments.coordinates.BlockPosArgument;
import net.minecraft.core.BlockPos;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.network.chat.ClickEvent;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.Style;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;

/**
 * @author KilaBash
 * @date 2023/2/9
 * @implNote ServerCommands
 */
public class ServerCommands {
	public static List<LiteralArgumentBuilder<CommandSourceStack>> createServerCommands() {
		return List.of(
				Commands.m_82127_("ldlib")
						.then(Commands.m_82127_("ui_editor")
								.executes(context -> {
									UIEditorFactory.INSTANCE.openUI(UIEditorFactory.INSTANCE,
											context.getSource().m_81375_());
									return 1;
								}))
						.then(Commands.m_82127_("copy_block_tag")
								.then(Commands.m_82129_("pos", BlockPosArgument.m_118239_())
										.executes(context -> {
											var pos = BlockPosArgument.m_118242_(context, "pos");
											var world = context.getSource().m_81372_();
											var blockEntity = world.m_7702_(pos);
											if (blockEntity != null) {
												var tag = blockEntity.m_187482_();
												var value = NbtUtils.m_178063_(tag);
												context.getSource().m_288197_(() -> Component
														.m_237113_("[Copy to clipboard]")
														.m_130948_(Style.f_131099_.m_131140_(ChatFormatting.YELLOW)
																.m_131142_(new ClickEvent(
																		ClickEvent.Action.COPY_TO_CLIPBOARD, value)))
														.m_7220_(NbtUtils.m_178061_(tag)), true);
											} else {
												context.getSource().m_288197_(
														() -> Component.m_237113_("No block entity at " + pos)
																.m_130948_(Style.f_131099_.m_131140_(ChatFormatting.RED)),
														true);
											}
											return 1;
										})))
						.then(Commands.m_82127_("copy_entity_tag")
								.then(Commands.m_82129_("entity", EntityArgument.m_91449_())
										.executes(context -> {
											var entity = EntityArgument.m_91452_(context, "entity");
											var tag = entity.m_20240_(new CompoundTag());
											var value = NbtUtils.m_178063_(tag);
											context.getSource().m_288197_(() -> Component
													.m_237113_("[Copy to clipboard]")
													.m_130948_(Style.f_131099_.m_131140_(ChatFormatting.YELLOW)
															.m_131142_(new ClickEvent(
																	ClickEvent.Action.COPY_TO_CLIPBOARD, value)))
													.m_7220_(NbtUtils.m_178061_(tag)), true);
											return 1;
										}))),
				Commands.m_82127_("compass_server").then(Commands.m_82127_("build_scene")
						.then(Commands.m_82129_("start", BlockPosArgument.m_118239_())
								.then(Commands.m_82129_("end", BlockPosArgument.m_118239_())
										.executes(context -> runBuildScene(context, false, new BlockPos(0, 0, 0)))
										.then(Commands.m_82129_("saveNbt", BoolArgumentType.bool())
												.executes(context -> runBuildScene(context,
														BoolArgumentType.getBool(context, "saveNbt"),
														new BlockPos(0, 0, 0)))
												.then(Commands.m_82129_("offset", BlockPosArgument.m_118239_())
														.executes(context -> runBuildScene(context,
																BoolArgumentType.getBool(context, "saveNbt"),
																BlockPosArgument.m_264582_(context, "offset")))))))));
	}

	public static int runBuildScene(CommandContext<CommandSourceStack> context, boolean saveNbt, BlockPos offset) {

		var start = BlockPosArgument.m_264582_(context, "start");
		var end = BlockPosArgument.m_264582_(context, "end");
		var world = context.getSource().m_81372_();

		int smallestX = start.m_123341_() <= end.m_123341_() ? start.m_123341_() : end.m_123341_();
		int smallestY = start.m_123342_() <= end.m_123342_() ? start.m_123342_() : end.m_123342_();
		int smallestZ = start.m_123343_() <= end.m_123343_() ? start.m_123343_() : end.m_123343_();

		int largestX = start.m_123341_() >= end.m_123341_() ? start.m_123341_() : end.m_123341_();
		int largestY = start.m_123342_() >= end.m_123342_() ? start.m_123342_() : end.m_123342_();
		int largestZ = start.m_123343_() >= end.m_123343_() ? start.m_123343_() : end.m_123343_();

		int offsetX = -((largestX - smallestX) / 2) + offset.m_123341_();
		int offsetY = offset.m_123342_();
		int offsetZ = -((largestZ - smallestZ) / 2) + offset.m_123343_();

		ArrayList<String> nodes = new ArrayList<>();

		for (int x = smallestX; x <= largestX; x++) {
			for (int y = smallestY; y <= largestY; y++) {
				for (int z = smallestZ; z <= largestZ; z++) {
					var block = world.m_8055_(new BlockPos(x, y, z));
					var blockentity = world
							.m_7702_(new BlockPos(x, y, z));
					if (block.m_60734_() != Blocks.f_50016_) {
						String id = BuiltInRegistries.f_256975_
								.m_7981_(block.m_60734_()).toString();
						nodes.add(
								String.format(
										"<add pos=\"%d %d %d\" block=\"%s\">",
										x - smallestX + offsetX, y - smallestY + offsetY,
										z - smallestZ + offsetZ, id));
						nodes.addAll(block.m_61148_().entrySet().stream()
								.map(e -> String.format(
										"<properties name=\"%s\" value=\"%s\" />",
										e.getKey().m_61708_(),
										e.getValue().toString()))
								.collect(Collectors.toList()));
						if (saveNbt && blockentity != null) {
							var tag = blockentity.m_187482_();
							nodes.add("<nbt>");
							nodes.add(NbtUtils.m_178061_(tag)
									.getString());
							nodes.add("</nbt>");
						}
						nodes.add("</add>");
					}
				}
			}
		}

		var text = nodes.stream().collect(Collectors.joining("\n"));

		context.getSource().m_288197_(() -> Component
				.m_237113_("[Copy XML to clipboard]")
				.m_130948_(Style.f_131099_.m_131140_(ChatFormatting.YELLOW)
						.m_131142_(new ClickEvent(
								ClickEvent.Action.COPY_TO_CLIPBOARD,
								text))),
				true);

		return 1;

	}
}
