package com.lowdragmc.lowdraglib.client.bakedpipeline;

import com.lowdragmc.lowdraglib.core.mixins.accessor.VertexFormatAccessor;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.VertexFormatElement;
import net.minecraft.client.renderer.block.model.BakedQuad;

import java.util.Arrays;
import java.util.List;

/**
 * @author KilaBash
 * @date 2023/2/20
 * @implNote IQuadTransformer
 */
public interface IQuadTransformer {
    int STRIDE = DefaultVertexFormat.f_85811_.m_86017_();
    int POSITION = findOffset(DefaultVertexFormat.f_85804_);
    int COLOR = findOffset(DefaultVertexFormat.f_85805_);
    int UV0 = findOffset(DefaultVertexFormat.f_85806_);
    int UV1 = findOffset(DefaultVertexFormat.f_85807_);
    int UV2 = findOffset(DefaultVertexFormat.f_85808_);
    int NORMAL = findOffset(DefaultVertexFormat.f_85809_);

    void processInPlace(BakedQuad arg);

    default void processInPlace(List<BakedQuad> quads) {
        for (BakedQuad quad : quads) {
            this.processInPlace(quad);
        }

    }

    default BakedQuad process(BakedQuad quad) {
        BakedQuad copy = copy(quad);
        this.processInPlace(copy);
        return copy;
    }

    default List<BakedQuad> process(List<BakedQuad> inputs) {
        return inputs.stream().map(IQuadTransformer::copy).peek(this::processInPlace).toList();
    }

    default IQuadTransformer andThen(IQuadTransformer other) {
        return (quad) -> {
            this.processInPlace(quad);
            other.processInPlace(quad);
        };
    }

    /** @deprecated */
    @Deprecated(
            forRemoval = true,
            since = "1.19"
    )
    static IQuadTransformer empty() {
        return QuadTransformers.empty();
    }


    /** @deprecated */
    @Deprecated(
            forRemoval = true,
            since = "1.19"
    )
    static IQuadTransformer applyingLightmap(int lightmap) {
        return QuadTransformers.applyingLightmap(lightmap);
    }

    private static BakedQuad copy(BakedQuad quad) {
        int[] vertices = quad.m_111303_();
        return new BakedQuad(Arrays.copyOf(vertices, vertices.length), quad.m_111305_(), quad.m_111306_(), quad.m_173410_(), quad.m_111307_());
    }

    private static int findOffset(VertexFormatElement element) {
        int index = DefaultVertexFormat.f_85811_.m_86023_().indexOf(element);
        return index < 0 ? -1 : ((VertexFormatAccessor)DefaultVertexFormat.f_85811_).getOffsets().getInt(index) / 4;
    }
}
