package com.lowdragmc.lowdraglib.client.model.custommodel;

import com.lowdragmc.lowdraglib.utils.ShapeUtils;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.util.Mth;
import net.minecraft.world.phys.AABB;
import javax.annotation.Nonnull;

/**
 * @author KilaBash
 * @date 2023/3/23
 * @implNote ConnectInfo
 */
public enum Connection {
    UP(Direction.UP),
    DOWN(Direction.DOWN),
    LEFT(Direction.EAST),
    RIGHT(Direction.WEST),
    UP_LEFT(Direction.UP, Direction.EAST),
    UP_RIGHT(Direction.UP, Direction.WEST),
    DOWN_LEFT(Direction.DOWN, Direction.EAST),
    DOWN_RIGHT(Direction.DOWN, Direction.WEST);

    public final Direction[] dirs;
    public final BlockPos[] offsets;

    Connection(Direction... dirs) {
        this.dirs = dirs;
        this.offsets = new BlockPos[6];
        for (var normal : Direction.values()) {
            var pos = BlockPos.f_121853_;
            for (Direction dir : dirs) {
                if (normal.m_122434_() == Direction.Axis.Y) {
                    dir = dir.m_122424_();
                }
                pos = pos.m_121945_(dir);
            }
            var rotated = ShapeUtils.rotate(new AABB(pos), normal);
            offsets[normal.ordinal()] = new BlockPos(Mth.m_14107_((rotated.f_82288_ + rotated.f_82291_) / 2), Mth.m_14107_((rotated.f_82289_ + rotated.f_82292_) / 2), Mth.m_14107_((rotated.f_82290_ + rotated.f_82293_) / 2));
        }
    }

    @Nonnull
    public BlockPos getOffset(Direction normal) {
        return this.offsets[normal.ordinal()];
    }

    @Nonnull
    public BlockPos transform(BlockPos pos, Direction normal) {
        return pos.m_121955_(getOffset(normal));
    }

    public Connection getOpposite() {
        return switch (this) {
            case UP -> DOWN;
            case DOWN -> UP;
            case LEFT -> RIGHT;
            case RIGHT -> LEFT;
            case UP_LEFT -> DOWN_RIGHT;
            case UP_RIGHT -> DOWN_LEFT;
            case DOWN_LEFT -> UP_RIGHT;
            case DOWN_RIGHT -> UP_LEFT;
        };
    }

}
