package com.lowdragmc.lowdraglib.client.renderer;

import com.mojang.blaze3d.vertex.PoseStack;
import lombok.NoArgsConstructor;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;

/**
 * Author: KilaBash
 * Date: 2022/04/21
 * Description: 
 */
@Environment(EnvType.CLIENT)
@ParametersAreNonnullByDefault
@MethodsReturnNonnullByDefault
public class ATESRRendererProvider<T extends BlockEntity> implements BlockEntityRenderer<T> {

    public ATESRRendererProvider() {
    }

    public ATESRRendererProvider(BlockEntityRendererProvider.Context ctx) {
    }

    @Override
    public int m_142163_() {
        return BlockEntityRenderer.super.m_142163_();
    }

    @Override
    public boolean m_142756_(T pBlockEntity, Vec3 pCameraPos) {
        IRenderer renderer = getRenderer(pBlockEntity);
        if (renderer != null) {
            return renderer.shouldRender(pBlockEntity, pCameraPos);
        }
        return BlockEntityRenderer.super.m_142756_(pBlockEntity, pCameraPos);
    }

    @Override
    public void m_6922_(T pBlockEntity, float pPartialTick, PoseStack pPoseStack, MultiBufferSource pBufferSource, int pPackedLight, int pPackedOverlay) {
        IRenderer renderer = getRenderer(pBlockEntity);
        if (renderer != null && !renderer.isRaw()) {
            renderer.render(pBlockEntity, pPartialTick, pPoseStack, pBufferSource, pPackedLight, pPackedOverlay);
        }
    }

    @Nullable
    public IRenderer getRenderer(@Nonnull T tileEntity) {
        Level world = tileEntity.m_58904_();
        if (world != null) {
            BlockState state = tileEntity.m_58900_();
            if (state.m_60734_() instanceof IBlockRendererProvider blockRendererProvider) {
                return blockRendererProvider.getRenderer(state);
            }
        }
        return null;
    }

    public boolean hasRenderer(T tileEntity) {
        IRenderer renderer = getRenderer(tileEntity);
        return renderer != null && renderer.hasTESR(tileEntity);
    }

    @Override
    public boolean m_5932_(@Nonnull T tileEntity) {
        IRenderer renderer = getRenderer(tileEntity);
        if (renderer != null) {
            return renderer.isGlobalRenderer(tileEntity);
        }
        return false;
    }
    
}

