package com.lowdragmc.lowdraglib.client.renderer.block;

import com.lowdragmc.lowdraglib.client.renderer.IBlockRendererProvider;
import com.lowdragmc.lowdraglib.client.renderer.IRenderer;
import net.minecraft.core.BlockPos;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.Nullable;

import javax.annotation.ParametersAreNonnullByDefault;

// used to present a renderer block
public class RendererBlock extends Block implements EntityBlock, IBlockRendererProvider {

    public static final RendererBlock BLOCK = new RendererBlock();
    private static final IRenderer renderer = new RendererBlockRenderer();

    private RendererBlock() {
        super(Properties.m_284310_().m_60955_().m_155954_(2));
    }

    @Nullable
    @Override
    @ParametersAreNonnullByDefault
    public BlockEntity m_142194_(BlockPos pPos, BlockState pState) {
        return new RendererBlockEntity(pPos, pState);
    }

    @Nullable
    @Override
    public IRenderer getRenderer(BlockState state) {
        return renderer;
    }
}
