package com.lowdragmc.lowdraglib.client.renderer.impl;

import com.lowdragmc.lowdraglib.LDLib;
import com.lowdragmc.lowdraglib.client.renderer.ISerializableRenderer;
import com.lowdragmc.lowdraglib.gui.editor.annotation.LDLRegisterClient;
import com.lowdragmc.lowdraglib.utils.BlockInfo;
import com.lowdragmc.lowdraglib.utils.FacadeBlockWorld;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import lombok.Getter;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.block.BlockRenderDispatcher;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.client.renderer.texture.TextureAtlas;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.material.FluidState;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import java.util.Collections;
import java.util.List;
import java.util.function.Consumer;

//@LDLRegisterClient(name = "block_model", group = "renderer")
public class BlockStateRenderer implements ISerializableRenderer {

    @Getter
    protected BlockInfo blockInfo;
    @Environment(EnvType.CLIENT)
    private BakedModel itemModel;

    protected BlockStateRenderer() {
        blockInfo = null;
    }

    public BlockStateRenderer(BlockState state) {
        this(BlockInfo.fromBlockState(state == null ? Blocks.f_50375_.m_49966_() : state));
    }

    public BlockStateRenderer(BlockInfo blockInfo) {
        this.blockInfo = blockInfo == null ? new BlockInfo(Blocks.f_50375_) : blockInfo;
        if (LDLib.isClient()) {
            registerEvent();
        }
    }

    public BlockState getState(@Nullable BlockState blockState) {
        BlockState state = getBlockInfo().getBlockState();
        if (blockState == null) return state;
        Direction facing = Direction.NORTH;
        if (blockState.m_61138_(BlockStateProperties.f_61372_)) {
            facing = blockState.m_61143_(BlockStateProperties.f_61372_);
        } else if (blockState.m_61138_(BlockStateProperties.f_61374_)) {
            facing = blockState.m_61143_(BlockStateProperties.f_61374_);
        }
        try {
            switch (facing) {
                case EAST -> state = state.m_60717_(Rotation.CLOCKWISE_90);
                case WEST -> state = state.m_60717_(Rotation.COUNTERCLOCKWISE_90);
                case SOUTH -> state = state.m_60717_(Rotation.CLOCKWISE_180);
            }
        } catch (Exception ignore) {

        }
        return state;
    }

    @Environment(EnvType.CLIENT)
    protected BakedModel getItemModel(ItemStack renderItem) {
        if (itemModel == null) {
            itemModel = Minecraft.m_91087_().m_91291_().m_174264_(renderItem, null, null, 0);
        }
        return itemModel;
    }

    @Override
    @Environment(EnvType.CLIENT)
    @Nonnull
    public TextureAtlasSprite getParticleTexture() {
        ItemStack renderItem = getBlockInfo().getItemStackForm();
        BakedModel model = getItemModel(renderItem);
        if (model == null) {
            return ISerializableRenderer.super.getParticleTexture();
        }
        return model.m_6160_();
    }

    @Override
    @Environment(EnvType.CLIENT)
    public void renderItem(ItemStack stack, ItemDisplayContext transformType, boolean leftHand, PoseStack poseStack, MultiBufferSource buffer, int combinedLight, int combinedOverlay, BakedModel model) {
        ItemRenderer itemRenderer = Minecraft.m_91087_().m_91291_();
        ItemStack renderItem = getBlockInfo().getItemStackForm();
        itemRenderer.m_115143_(renderItem, transformType, leftHand, poseStack, buffer, combinedLight, combinedOverlay, getItemModel(renderItem));
    }

    @Override
    @Environment(EnvType.CLIENT)
    public boolean useBlockLight(ItemStack stack) {
        ItemStack renderItem = getBlockInfo().getItemStackForm();
        var model = getItemModel(renderItem);
        if (model != null) {
            return model.m_7547_();
        }
        return false;
    }

    @Override
    @Environment(EnvType.CLIENT)
    public List<BakedQuad> renderModel(@Nullable BlockAndTintGetter level, @Nullable BlockPos pos, @Nullable BlockState state, @Nullable Direction side, RandomSource rand) {
        state = getState(state);
        if (state.m_60799_() != RenderShape.INVISIBLE) {
            BlockRenderDispatcher brd = Minecraft.m_91087_().m_91289_();
            BakedModel model = brd.m_110910_(state);
            return model.m_213637_(state, side, rand);
        }
        return Collections.emptyList();
    }

    @Environment(EnvType.CLIENT)
    @Nullable
    public BlockEntity getBlockEntity(BlockAndTintGetter world, BlockPos pos) {
        BlockInfo blockInfo = getBlockInfo();
        BlockEntity tile = blockInfo.getBlockEntity(pos);
        if (tile != null && world instanceof Level) {
            try {
                var state = getState(world.m_8055_(pos));
                tile.m_155250_(state);
                tile.m_142339_(new FacadeBlockWorld((Level) world, pos, state, tile));
            } catch (Throwable throwable) {
                blockInfo.setHasBlockEntity(false);
            }
        }
        return tile;
    }

    @Override
    @Environment(EnvType.CLIENT)
    public boolean hasTESR(BlockEntity tileEntity) {
        if (!getBlockInfo().getBlockState().getFluidState().isEmpty()) {
            return true;
        }
        tileEntity = getBlockEntity(tileEntity.m_58904_(), tileEntity.m_58899_());
        if (tileEntity == null) {
            return false;
        }
        return Minecraft.m_91087_().m_167982_().m_112265_(tileEntity) != null;
    }

    @Override
    @Environment(EnvType.CLIENT)
    public boolean isGlobalRenderer(BlockEntity tileEntity) {
        tileEntity = getBlockEntity(tileEntity.m_58904_(), tileEntity.m_58899_());
        if (tileEntity == null) return false;
        BlockEntityRenderer<BlockEntity> tesr = Minecraft.m_91087_().m_167982_().m_112265_(tileEntity);
        if (tesr != null) {
            return tesr.m_5932_(tileEntity);
        }
        return false;
    }

    @Override
    @Environment(EnvType.CLIENT)
    public void render(BlockEntity tileEntity, float partialTicks, PoseStack stack, MultiBufferSource buffer, int combinedLight, int combinedOverlay) {
        BlockInfo block = getBlockInfo();
        FluidState fluidState = block.getBlockState().m_60819_();
        if (!fluidState.m_76178_()) {
            VertexConsumer builder = buffer.m_6299_(RenderType.m_110466_());
            Minecraft.m_91087_().m_91289_().m_234363_(tileEntity.m_58899_(), tileEntity.m_58904_(), builder, block.getBlockState(), fluidState);
        }
        tileEntity = getBlockEntity(tileEntity.m_58904_(), tileEntity.m_58899_());
        if (tileEntity == null) return;
        BlockEntityRenderer<BlockEntity> tesr = Minecraft.m_91087_().m_167982_().m_112265_(tileEntity);
        if (tesr != null) {
            try {
                tesr.m_6922_(tileEntity, partialTicks, stack, buffer, combinedLight, combinedOverlay);
            } catch (Exception e){
                getBlockInfo().setHasBlockEntity(false);
            }
        }
    }

    @Override
    @Environment(EnvType.CLIENT)
    public void onPrepareTextureAtlas(ResourceLocation atlasName, Consumer<ResourceLocation> register) {
        if (atlasName.equals(TextureAtlas.f_118259_)) {
            itemModel = null;
        }
    }

    @Override
    @Environment(EnvType.CLIENT)
    public boolean useAO() {
        var state = getBlockInfo().getBlockState();
        if (state.getRenderShape() != RenderShape.INVISIBLE) {
            return Minecraft.m_91087_().m_91289_().m_110910_(state).useAmbientOcclusion();
        }
        return false;
    }

    @Override
    @Environment(EnvType.CLIENT)
    public boolean isGui3d() {
        var model = getItemModel(getBlockInfo().getItemStackForm());
        if (model == null) {
            return ISerializableRenderer.super.isGui3d();
        }
        return model.isGui3d();
    }
}
