package com.lowdragmc.lowdraglib.client.scene;

import com.lowdragmc.lowdraglib.utils.PositionedRect;
import com.mojang.blaze3d.platform.Window;
import com.mojang.blaze3d.systems.RenderSystem;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.client.Minecraft;
import net.minecraft.world.level.Level;
import org.lwjgl.opengl.GL11;

/**
 * Created with IntelliJ IDEA.
 * @Author: KilaBash
 * @Date: 2021/8/24
 * @Description: Real-time rendering renderer.
 * If you need to render scene as a texture, use the FBO {@link FBOWorldSceneRenderer}.
 */
@Environment(EnvType.CLIENT)
public class ImmediateWorldSceneRenderer extends WorldSceneRenderer {

    public ImmediateWorldSceneRenderer(Level world) {
        super(world);
    }

    @Override
    public PositionedRect getPositionedRect(int x, int y, int width, int height) {
        Window window = Minecraft.m_91087_().m_91268_();
        //compute window size from scaled width & height
        int windowWidth = (int) (width / (window.m_85445_() * 1.0) * window.m_85441_());
        int windowHeight = (int) (height / (window.m_85446_() * 1.0) * window.m_85442_());
        //translate gui coordinates to window's ones (y is inverted)
        int windowX = (int) (x / (window.m_85445_() * 1.0) * window.m_85441_());
        int windowY = window.m_85442_() - (int) (y / (window.m_85446_() * 1.0) * window.m_85442_()) - windowHeight;

        return super.getPositionedRect(windowX, windowY, windowWidth, windowHeight);
    }

    @Override
    public PositionedRect getPositionRectRevert(int windowX, int windowY, int windowWidth, int windowHeight) {
        Window window = Minecraft.m_91087_().m_91268_();
        //compute window size from scaled width & height
        int width = windowWidth * window.m_85445_() / window.m_85441_();
        int height = windowHeight * window.m_85446_() / window.m_85442_();
        //translate window coordinates to gui's ones (y is inverted)
        int x = windowX  * window.m_85445_() / window.m_85441_();
        int y = (window.m_85442_() - windowY - windowHeight) * window.m_85446_() / window.m_85442_();

        return super.getPositionRectRevert(x, y, width, height);
    }

    @Override
    protected void clearView(int x, int y, int width, int height) {
        int a = (clearColor & 0xFF000000) >> 24;
        if (a == 0) {
            RenderSystem.clear(GL11.GL_DEPTH_BUFFER_BIT, Minecraft.f_91002_);
            return;
        }
        GL11.glEnable(GL11.GL_SCISSOR_TEST);
        GL11.glScissor(x, y, width, height);
        super.clearView(x, y, width, height);
        GL11.glDisable(GL11.GL_SCISSOR_TEST);
    }
}
