package com.lowdragmc.lowdraglib.client.shader;

import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.VertexFormat;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.client.renderer.RenderStateShard;
import net.minecraft.client.renderer.RenderType;
import org.lwjgl.opengl.GL11;

import java.util.OptionalDouble;

@Environment(EnvType.CLIENT)
public class LDLibRenderTypes extends RenderType {
    private static final RenderType POSITION_COLOR_NO_DEPTH = m_173215_("position_color_no_depth",
            DefaultVertexFormat.f_85815_, VertexFormat.Mode.TRIANGLES, 256, false, false,
            RenderType.CompositeState.m_110628_()
                    .m_173292_(RenderStateShard.f_173104_)
                    .m_110685_(f_110139_)
                    .m_110663_(f_110111_)
                    .m_110691_(false));

    private static final RenderType NO_DEPTH_LINES = m_173215_("lines_no_depth",
            DefaultVertexFormat.f_166851_, VertexFormat.Mode.LINES, 256, false, false,
            RenderType.CompositeState.m_110628_()
                    .m_173292_(f_173095_)
                    .m_110673_(new RenderStateShard.LineStateShard(OptionalDouble.of(3f)))
                    .m_110669_(f_110119_)
                    .m_110685_(f_110139_)
                    .m_110675_(f_110129_)
                    .m_110663_(f_110111_)
                    .m_110687_(f_110115_)
                    .m_110661_(f_110110_)
                    .m_110691_(false));




    public LDLibRenderTypes(String name, VertexFormat format, VertexFormat.Mode mode, int bufferSize, boolean affectsCrumbling, boolean sortOnUpload, Runnable setupState, Runnable clearState) {
        super(name, format, mode, bufferSize, affectsCrumbling, sortOnUpload, setupState, clearState);
    }

    public static RenderType positionColorNoDepth() {
        return POSITION_COLOR_NO_DEPTH;
    }

    public static RenderType noDepthLines() {
        return NO_DEPTH_LINES;
    }

}
