package com.lowdragmc.lowdraglib.client.shader.management;

import com.lowdragmc.lowdraglib.client.shader.Shaders;
import com.lowdragmc.lowdraglib.client.shader.uniform.IUniformCallback;
import com.lowdragmc.lowdraglib.utils.PositionedRect;
import com.mojang.blaze3d.pipeline.RenderTarget;
import com.mojang.blaze3d.pipeline.TextureTarget;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.*;
import it.unimi.dsi.fastutil.objects.Reference2ReferenceMap;
import it.unimi.dsi.fastutil.objects.Reference2ReferenceOpenHashMap;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.client.Minecraft;

import java.util.function.Consumer;

@Environment(EnvType.CLIENT)
public class ShaderManager {

	private static final ShaderManager INSTANCE = new ShaderManager();

	public static ShaderManager getInstance() {
		return INSTANCE;
	}

	public static boolean allowedShader() {
		return true;
	}

	private final Reference2ReferenceMap<Shader, ShaderProgram> programs;

	private ShaderManager() {
		this.programs = new Reference2ReferenceOpenHashMap<>();
	}

	private static TextureTarget TEMP_TARGET;
	public static TextureTarget getTempTarget() {
		if (TEMP_TARGET == null) {
			TEMP_TARGET = new TextureTarget(1024, 1024, false, Minecraft.f_91002_);
			TEMP_TARGET.m_83936_(9729);
			TEMP_TARGET.m_83931_(0, 0, 0, 0);
		}
		return TEMP_TARGET;
	}

	public void reload() {
		programs.forEach((shader, shaderProgram) -> {
			shader.deleteShader();
			shaderProgram.delete();
		});
		programs.clear();
	}

	private PositionedRect viewPort;

	public void setViewPort(PositionedRect viewPort) {
		this.viewPort = viewPort;
	}

	public boolean hasViewPort() {
		return this.viewPort != null;
	}

	public void clearViewPort() {
		this.viewPort = null;
	}

	public RenderTarget renderFullImageInFramebuffer(RenderTarget fbo, Shader frag, IUniformCallback consumeCache, Consumer<ShaderProgram> programCreated) {
		if (fbo == null || frag == null || !allowedShader() || frag.shaderType != Shader.ShaderType.FRAGMENT) {
			return fbo;
		}

		fbo.m_83947_(true);
		ShaderProgram program = programs.get(frag);
		if (program == null) {
			programs.put(frag, program = new ShaderProgram());
			program.attach(Shaders.IMAGE_V).attach(frag);
			if (programCreated != null) {
				programCreated.accept(program);
			}
		}

		program.use(cache -> {
			Minecraft mc = Minecraft.m_91087_();
			float time;
			if (mc.f_91074_ != null) {
				time = (mc.f_91074_.f_19797_ + mc.m_91296_()) / 20;
			} else {
				time = System.currentTimeMillis() / 1000f;
			}
			cache.glUniform1F("iTime", time);
			cache.glUniform2F("iResolution", fbo.f_83915_, fbo.f_83916_);
			if (consumeCache != null) {
				consumeCache.apply(cache);
			}
		});

		Tesselator tessellator = Tesselator.m_85913_();
		BufferBuilder buffer = tessellator.m_85915_();
		buffer.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85814_);
		buffer.m_5483_(-1, 1, 0).m_5752_();
		buffer.m_5483_(-1, -1, 0).m_5752_();
		buffer.m_5483_(1, -1, 0).m_5752_();
		buffer.m_5483_(1, 1, 0).m_5752_();
		BufferUploader.m_231209_(buffer.m_231175_());

		program.release();

		if (viewPort != null) {
			RenderSystem.viewport(viewPort.position.x, viewPort.position.y, viewPort.size.width, viewPort.size.height);
		}
		return fbo;
	}

}
