package com.lowdragmc.lowdraglib.client.utils;

import com.lowdragmc.lowdraglib.Platform;
import com.lowdragmc.lowdraglib.client.shader.Shaders;
import com.mojang.blaze3d.pipeline.RenderTarget;
import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.*;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import org.lwjgl.opengl.GL;
import org.lwjgl.opengl.GL43;

/**
 * @author KilaBash
 * @date 2022/12/11
 * @implNote ShaderUtils
 */
@Environment(EnvType.CLIENT)
public class ShaderUtils {

    /**
     * fast blit - fast copy a fbo to another one (color component)
     * @param from fbo
     * @param to fbo
     */
    public static void fastBlit(RenderTarget from, RenderTarget to) {
        RenderSystem.assertOnRenderThread();
        GlStateManager._colorMask(true, true, true, true);
        GlStateManager._disableDepthTest();
        GlStateManager._depthMask(false);

        to.m_83947_(true);

        Shaders.getBlitShader().setSampler("DiffuseSampler", from.m_83975_());

        Shaders.getBlitShader().apply();
        GlStateManager._enableBlend();
        RenderSystem.defaultBlendFunc();

        Tesselator tesselator = RenderSystem.renderThreadTesselator();
        BufferBuilder bufferbuilder = tesselator.m_85915_();
        bufferbuilder.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85814_);
        bufferbuilder.m_5483_(-1, 1, 0).m_5752_();
        bufferbuilder.m_5483_(-1, -1, 0).m_5752_();
        bufferbuilder.m_5483_(1, -1, 0).m_5752_();
        bufferbuilder.m_5483_(1, 1, 0).m_5752_();
        BufferUploader.m_231209_(bufferbuilder.m_231175_());
        Shaders.getBlitShader().clear();

        GlStateManager._depthMask(true);
        GlStateManager._colorMask(true, true, true, true);
        GlStateManager._enableDepthTest();
    }

    private static final boolean DEBUG_LABEL_AVAILABLE = GL.getCapabilities().GL_KHR_debug;

    public static void warpGLDebugLabel(String message, Runnable block) {
        if (DEBUG_LABEL_AVAILABLE && Platform.isDevEnv()) {
            GL43.glPushDebugGroup(GL43.GL_DEBUG_SOURCE_APPLICATION, 0, message);
            block.run();
            GL43.glPopDebugGroup();
        } else {
            block.run();
        }
    }
}
