package com.lowdragmc.lowdraglib.client.utils;

import com.lowdragmc.lowdraglib.gui.util.WidgetTooltipComponent;
import com.lowdragmc.lowdraglib.jei.ModularWrapper;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.inventory.tooltip.ClientTooltipComponent;

import javax.annotation.ParametersAreNonnullByDefault;

/**
 * @author KilaBash
 * @date 2023/6/29
 * @implNote WidgetClientTooltipComponent
 */
@MethodsReturnNonnullByDefault
@ParametersAreNonnullByDefault
@Environment(EnvType.CLIENT)
public record WidgetClientTooltipComponent(WidgetTooltipComponent tooltipComponent) implements ClientTooltipComponent {
    @Override
    public int m_142103_() {
        return tooltipComponent.widget().getSize().height;
    }

    @Override
    public int m_142069_(Font font) {
        return tooltipComponent.widget().getSize().width;
    }

    @Override
    public void m_183452_(Font textRenderer, int x, int y, GuiGraphics graphics) {
        var modularWrapper = new ModularWrapper<>(tooltipComponent.widget());
        modularWrapper.setRecipeWidget(x, y);
        modularWrapper.draw(graphics, 0, 0, Minecraft.m_91087_().m_91296_());
    }
}
