package com.lowdragmc.lowdraglib.core.mixins;

import blue.endless.jankson.annotation.Nullable;
import com.lowdragmc.lowdraglib.client.renderer.IItemRendererProvider;
import com.lowdragmc.lowdraglib.client.renderer.IRenderer;
import net.minecraft.client.renderer.ItemModelShaper;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.ItemOverrides;
import net.minecraft.client.renderer.block.model.ItemTransforms;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.core.Direction;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.state.BlockState;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

import java.util.HashMap;
import java.util.List;
import java.util.Map;

@Mixin(ItemModelShaper.class)
public class ItemModelShaperMixin {
    @Unique
    private final static Map<IRenderer, BakedModel> SHAPES_CACHE = new HashMap<>();

    @Inject(method = "getItemModel(Lnet/minecraft/world/item/ItemStack;)Lnet/minecraft/client/resources/model/BakedModel;", at = @At("HEAD"), cancellable = true)
    public void injectGetModel(ItemStack stack, CallbackInfoReturnable<BakedModel> cir) {
        if (stack.m_41720_() instanceof IItemRendererProvider provider) {
            IRenderer renderer = provider.getRenderer(stack);
            if(renderer != null) {
                cir.setReturnValue(SHAPES_CACHE.computeIfAbsent(renderer, r -> new BakedModel() {
                    @Override
                    public List<BakedQuad> m_213637_(@Nullable BlockState state, @Nullable Direction direction, RandomSource random) {
                        return r.renderModel(null, null, state, direction, random);
                    }

                    @Override
                    public boolean m_7541_() {
                        return r.useAO();
                    }

                    @Override
                    public boolean m_7539_() {
                        return renderer.isGui3d();
                    }

                    @Override
                    public boolean m_7547_() {
                        return r.useBlockLight(stack);
                    }

                    @Override
                    public boolean m_7521_() {
                        return false;
                    }

                    @Override
                    public TextureAtlasSprite m_6160_() {
                        return r.getParticleTexture();
                    }

                    @Override
                    public ItemTransforms m_7442_() {
                        return ItemTransforms.f_111786_;
                    }

                    @Override
                    public ItemOverrides m_7343_() {
                        return ItemOverrides.f_111734_;
                    }
                }));
            }
        }
    }
}
