package com.lowdragmc.lowdraglib.core.mixins;

import com.lowdragmc.lowdraglib.client.renderer.IItemRendererProvider;
import com.lowdragmc.lowdraglib.client.renderer.IRenderer;
import com.mojang.blaze3d.platform.Lighting;
import com.mojang.blaze3d.vertex.PoseStack;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(ItemRenderer.class)
public abstract class ItemRendererMixin {

    @Inject(method = "render", at = @At(value = "HEAD"), cancellable = true)
    public void injectRenderItem(ItemStack stack, 
                                 ItemDisplayContext itemDisplayContext, 
                                 boolean leftHanded, 
                                 PoseStack matrices, 
                                 MultiBufferSource buffer,
                                 int light, int overlay, 
                                 BakedModel model,
                                 CallbackInfo ci){
        if (stack.m_41720_() instanceof IItemRendererProvider && !IItemRendererProvider.disabled.get()) {
            IRenderer renderer =((IItemRendererProvider) stack.m_41720_()).getRenderer(stack);
            if (renderer != null) {
                if (itemDisplayContext == ItemDisplayContext.GUI) {
                    if (renderer.useBlockLight(stack) != model.m_7547_()) {
                        if (renderer.useBlockLight(stack)) {
                            Lighting.m_84931_();
                        } else {
                            Lighting.m_84930_();
                        }
                    }
                }
                renderer.renderItem(stack, itemDisplayContext, leftHanded, matrices, buffer, light, overlay, model);
                if (itemDisplayContext == ItemDisplayContext.GUI) {
                    if (buffer instanceof MultiBufferSource.BufferSource bufferSource) {
                        bufferSource.m_109911_();
                        if (model.m_7547_()) {
                            Lighting.m_84931_();
                        } else {
                            Lighting.m_84930_();
                        }
                    }
                }
                ci.cancel();
            }
        }
    }

}
