package com.lowdragmc.lowdraglib.emi;

import com.lowdragmc.lowdraglib.gui.ingredient.Target;
import com.lowdragmc.lowdraglib.gui.modular.ModularUIGuiContainer;
import dev.emi.emi.api.EmiDragDropHandler;
import dev.emi.emi.api.EmiExclusionArea;
import dev.emi.emi.api.EmiStackProvider;
import dev.emi.emi.api.stack.EmiIngredient;
import dev.emi.emi.api.stack.EmiStack;
import dev.emi.emi.api.stack.EmiStackInteraction;
import dev.emi.emi.api.widget.Bounds;

import java.util.List;
import net.minecraft.client.renderer.Rect2i;

/**
 * @author KilaBash
 * @date 2023/4/3
 * @implNote ModularUIEmiHandlers
 */
public final class ModularUIEmiHandlers {
    public static final EmiDragDropHandler<ModularUIGuiContainer> DRAG_DROP_HANDLER = (screen, stack, x, y) -> {
        var stacks = stack.getEmiStacks();
        if (stacks.isEmpty()) return false;
        for (EmiStack emiStack : stacks) {
            List<Target> targets = screen.modularUI.mainGroup.getPhantomTargets(emiStack);
            if (targets.isEmpty()) continue;
            for (Target target : targets) {
                var area = target.getArea();
                if (area.m_110087_(x, y)) {
                    target.accept(emiStack);
                    return true;
                }
            }
        }
        return false;
    };
    public static final EmiExclusionArea<ModularUIGuiContainer> EXCLUSION_AREA = (screen, consumer) -> screen.getGuiExtraAreas().stream().map(rect2 -> new Bounds(rect2.m_110085_(), rect2.m_110086_(), rect2.m_110090_(), rect2.m_110091_())).forEach(consumer);
    public static final EmiStackProvider<ModularUIGuiContainer> STACK_PROVIDER = (screen, x, y) -> {
        var target = screen.modularUI.mainGroup.getXEIIngredientOverMouse(x, y);
        if (target instanceof EmiStackInteraction entryStack) {
            return entryStack;
        } else if (target instanceof EmiIngredient entryStacks) {
            return new EmiStackInteraction(entryStacks, null, false);
        }
        return EmiStackInteraction.EMPTY;
    };
}
