package com.lowdragmc.lowdraglib.emi;

import com.lowdragmc.lowdraglib.gui.ingredient.IRecipeIngredientSlot;
import com.lowdragmc.lowdraglib.gui.util.DrawerHelper;
import com.lowdragmc.lowdraglib.jei.ModularWrapper;
import dev.emi.emi.api.widget.Bounds;
import dev.emi.emi.api.widget.Widget;
import lombok.Getter;
import lombok.Setter;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.events.ContainerEventHandler;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.inventory.tooltip.ClientTooltipComponent;
import net.minecraft.network.chat.Component;
import org.jetbrains.annotations.Nullable;

import javax.annotation.Nonnull;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;

/**
 * @author KilaBash
 * @date 2023/4/3
 * @implNote ModularWrapperWidget
 */
@Environment(EnvType.CLIENT)
public class ModularWrapperWidget extends Widget implements ContainerEventHandler {
    @Getter @Setter
    @Nullable
    private GuiEventListener focused;
    @Getter @Setter
    private boolean isDragging;
    public final ModularWrapper<?> modular;
    public final List<Widget> slots;

    public ModularWrapperWidget(ModularWrapper<?> modular, List<Widget> slots) {
        this.modular = modular;
        this.slots = slots;
    }

    @Override
    public Bounds getBounds() {
        return new Bounds(0, 0, modular.getWidget().getSize().width, modular.getWidget().getSize().height);
    }

    @Override
    public void m_88315_(@Nonnull GuiGraphics graphics, int pMouseX, int pMouseY, float pPartialTick) {
        modular.draw(graphics, pMouseX, pMouseY, pPartialTick);
    }

    @Override
    public List<ClientTooltipComponent> getTooltip(int mouseX, int mouseY) {
        if (modular.tooltipTexts != null && !modular.tooltipTexts.isEmpty() &&
                !(modular.modularUI.mainGroup.getHoverElement(mouseX + modular.getLeft(), mouseY + modular.getTop()) instanceof IRecipeIngredientSlot)) {
            List<ClientTooltipComponent> tooltips = modular.tooltipTexts.stream().map(Component::m_7532_).map(ClientTooltipComponent::m_169948_).collect(Collectors.toList());
            if (modular.tooltipComponent != null) {
                tooltips.add(DrawerHelper.getClientTooltipComponent(modular.tooltipComponent));
            }
            return tooltips;
        }
        return super.getTooltip(mouseX, mouseY);
    }

    @Override
    public List<? extends GuiEventListener> m_6702_() {
        return Collections.emptyList();
    }

    @Override
    public boolean m_6375_(double pMouseX, double pMouseY, int pButton) {
        return modular.m_6375_(pMouseX, pMouseY, pButton);
    }

    @Override
    public boolean mouseClicked(int mouseX, int mouseY, int button) {
        if (modular.m_6375_(mouseX + modular.getLeft(), mouseY + modular.getTop(), button)) {
            return true;
        }
        return super.mouseClicked(mouseX, mouseY, button);
    }

    @Override
    public boolean m_6348_(double pMouseX, double pMouseY, int pButton) {
        return modular.m_6348_(pMouseX, pMouseY, pButton);
    }

    @Override
    public void m_94757_(double pMouseX, double pMouseY) {
        modular.m_94757_(pMouseX, pMouseY);
    }

    @Override
    public boolean m_7979_(double pMouseX, double pMouseY, int pButton, double pDragX, double pDragY) {
        return modular.m_7979_(pMouseX, pMouseY, pButton, pDragX, pDragY);
    }

    @Override
    public boolean m_6050_(double pMouseX, double pMouseY, double pDelta) {
        return modular.m_6050_(pMouseX, pMouseY, pDelta);
    }

    @Override
    public boolean m_7933_(int pKeyCode, int pScanCode, int pModifiers) {
        return modular.m_7933_(pKeyCode, pScanCode, pModifiers);
    }

    @Override
    public boolean m_7920_(int pKeyCode, int pScanCode, int pModifiers) {
        return modular.m_7920_(pKeyCode, pScanCode, pModifiers);
    }

    @Override
    public boolean m_5534_(char pCodePoint, int pModifiers) {
        return modular.m_5534_(pCodePoint, pModifiers);
    }
}
