package com.lowdragmc.lowdraglib.gui.compass.component;

import com.lowdragmc.lowdraglib.gui.compass.CompassManager;
import com.lowdragmc.lowdraglib.gui.compass.ILayoutComponent;
import com.lowdragmc.lowdraglib.gui.compass.LayoutPageWidget;
import com.lowdragmc.lowdraglib.gui.widget.ComponentPanelWidget;
import com.lowdragmc.lowdraglib.utils.Size;
import com.lowdragmc.lowdraglib.utils.XmlUtils;
import lombok.NoArgsConstructor;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.Style;
import org.w3c.dom.Element;

import java.util.ArrayList;
import java.util.List;

/**
 * @author KilaBash
 * @date 2022/9/3
 * @implNote TextBoxComponent
 */
@NoArgsConstructor
public class TextBoxComponent extends AbstractComponent {
    protected List<Component> components = new ArrayList<>();
    protected int space = 2;
    protected boolean isCenter;

    @Override
    public ILayoutComponent fromXml(Element element) {
        super.fromXml(element);
        components.addAll(XmlUtils.getComponents(element, Style.f_131099_));
        space = XmlUtils.getAsInt(element, "space", space);
        if (element.hasAttribute("isCenter")) {
            isCenter = XmlUtils.getAsBoolean(element, "isCenter", true);
        }
        return this;
    }

    @Override
    @Environment(EnvType.CLIENT)
    protected LayoutPageWidget addWidgets(LayoutPageWidget currentPage) {
        var panel = new ComponentPanelWidget(0, 0, components) {
            @Override
            public void updateComponentTextSize() {
                var fontRenderer = Minecraft.m_91087_().f_91062_;
                int totalHeight = cacheLines.size() * (fontRenderer.f_92710_ + space);
                if (totalHeight > 0) {
                    totalHeight -= space;
                    totalHeight += 2;
                }
                setSize(new Size(maxWidthLimit, totalHeight));
            }
        }.setSpace(space).setCenter(isCenter).setMaxWidthLimit(width(currentPage)).clickHandler(CompassManager::onComponentClick);
        return currentPage.addStreamWidget(wrapper(panel));
    }

}
