package com.lowdragmc.lowdraglib.gui.editor.accessors;

import com.lowdragmc.lowdraglib.gui.editor.annotation.ConfigAccessor;
import com.lowdragmc.lowdraglib.gui.editor.annotation.Configurable;
import com.lowdragmc.lowdraglib.gui.editor.annotation.DefaultValue;
import com.lowdragmc.lowdraglib.gui.editor.configurator.*;
import com.lowdragmc.lowdraglib.gui.widget.SlotWidget;
import com.lowdragmc.lowdraglib.misc.ItemStackTransfer;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;

import java.lang.reflect.Field;
import java.util.function.Consumer;
import java.util.function.Supplier;

@ConfigAccessor
public class BlockStateAccessor extends TypesAccessor<BlockState> {

    public BlockStateAccessor() {
        super(BlockState.class);
    }

    @Override
    public BlockState defaultValue(Field field, Class<?> type) {
        if (field.isAnnotationPresent(DefaultValue.class)) {
            var annotation = field.getAnnotation(DefaultValue.class);
            return BuiltInRegistries.f_256975_.m_7745_(new ResourceLocation(annotation.stringValue()[0])).m_49966_();
        }
        return Blocks.f_50016_.m_49966_();
    }

    @Override
    public Configurator create(String name, Supplier<BlockState> supplier, Consumer<BlockState> consumer, boolean forceUpdate, Field field) {
        ConfiguratorGroup group = new ConfiguratorGroup(name);
        if (field.isAnnotationPresent(Configurable.class)) {
            Configurable configurable = field.getAnnotation(Configurable.class);
            group.setCollapse(configurable.collapse());
            group.setCanCollapse(configurable.canCollapse());
            group.setTips(configurable.tips());
        }
        var propertyGroup = new ConfiguratorGroup("ldlib.gui.editor.blockstate.properties");
        var itemHandler = new ItemStackTransfer(supplier.get().m_60734_().m_5456_().m_7968_());
        var slot = new SlotWidget(itemHandler, 0, 0, 0, false, false);
        slot.setClientSideWidget();
        Runnable updateProperty = () -> {
            propertyGroup.removeAllConfigurators();
            for (Property property : supplier.get().m_61147_()) {
                var propertySelector = new SelectorConfigurator<>(
                        property.m_61708_(),
                        () -> supplier.get().m_61143_(property),
                        value -> {
                            var state = supplier.get();
                            state = state.m_61124_(property, value);
                            consumer.accept(state);
                        }, supplier.get().m_61143_(property), forceUpdate,
                        property.m_6908_().stream().toList(),
                        property::getName);
                propertyGroup.addConfigurators(propertySelector);
            }
            propertyGroup.computeLayout();
        };
        updateProperty.run();
        Consumer<BlockState> updateState = state -> {
            consumer.accept(state);
            itemHandler.setStackInSlot(0, state.m_60734_().m_5456_().m_7968_());
            updateProperty.run();
        };
        group.addConfigurators(new BlockConfigurator("id",
                () -> supplier.get().m_60734_(),
                block -> updateState.accept(block.m_49966_()), Blocks.f_50016_, forceUpdate));
        group.addConfigurators(new WrapperConfigurator("ldlib.gui.editor.group.preview", slot));
        group.addConfigurators(propertyGroup);
        return group;
    }

}
