package com.lowdragmc.lowdraglib.gui.editor.configurator;

import I;
import com.lowdragmc.lowdraglib.utils.Size;
import net.minecraft.world.phys.AABB;

import java.util.function.Consumer;
import java.util.function.Supplier;


public class AABBConfigurator extends ValueConfigurator<AABB> {

    public AABBConfigurator(String name, Supplier<AABB> supplier, Consumer<AABB> onUpdate, AABB defaultValue, boolean forceUpdate) {
        super(name, supplier, onUpdate, defaultValue, forceUpdate);
        setSize(new Size(200, 15 * 2));
        if (value == null) {
            value = defaultValue;
        }
    }

    @Override
    protected void onValueUpdate(AABB newValue) {
        if (newValue == null) newValue = defaultValue;
        if (newValue.equals(value)) return;
        super.onValueUpdate(newValue);
    }

    @Override
    public void init(int width) {
        super.init(width);
        assert value != null;
        var w = (width - leftWidth - rightWidth) / 3;
        var minX = new NumberConfigurator("minX", () -> this.value.f_82288_, number -> {
            var newValue = new AABB(number.doubleValue(), this.value.f_82289_, this.value.f_82290_, this.value.f_82291_, this.value.f_82292_, this.value.f_82293_);
            onValueUpdate(newValue);
            updateValue();
        }, defaultValue.f_82288_, forceUpdate);
        minX.setRange(-Double.MAX_VALUE, Double.MAX_VALUE);
        minX.setWheel(0.1);
        minX.setConfiguratorContainer(configuratorContainer);
        minX.init(w);
        minX.addSelfPosition(leftWidth, 0);
        addWidget(minX);

        var minY = new NumberConfigurator("minY", () -> this.value.f_82289_, number -> {
            var newValue = new AABB(this.value.f_82288_, number.doubleValue(), this.value.f_82290_, this.value.f_82291_, this.value.f_82292_, this.value.f_82293_);
            onValueUpdate(newValue);
            updateValue();
        }, defaultValue.f_82289_, forceUpdate);
        minY.setRange(-Double.MAX_VALUE, Double.MAX_VALUE);
        minY.setWheel(0.1);
        minY.setConfiguratorContainer(configuratorContainer);
        minY.init(w);
        minY.addSelfPosition(leftWidth + w, 0);
        addWidget(minY);

        var minZ = new NumberConfigurator("minZ", () -> this.value.f_82290_, number -> {
            var newValue = new AABB(this.value.f_82288_, this.value.f_82289_, number.doubleValue(), this.value.f_82291_, this.value.f_82292_, this.value.f_82293_);
            onValueUpdate(newValue);
            updateValue();
        }, defaultValue.f_82290_, forceUpdate);
        minZ.setRange(-Double.MAX_VALUE, Double.MAX_VALUE);
        minZ.setWheel(0.1);
        minZ.setConfiguratorContainer(configuratorContainer);
        minZ.init(w);
        minZ.addSelfPosition(leftWidth + w * 2, 0);
        addWidget(minZ);

        var maxX = new NumberConfigurator("maxX", () -> this.value.f_82291_, number -> {
            var newValue = new AABB(this.value.f_82288_, this.value.f_82289_, this.value.f_82290_, number.doubleValue(), this.value.f_82292_, this.value.f_82293_);
            onValueUpdate(newValue);
            updateValue();
        }, defaultValue.f_82291_, forceUpdate);
        maxX.setRange(-Double.MAX_VALUE, Double.MAX_VALUE);
        maxX.setWheel(0.1);
        maxX.setConfiguratorContainer(configuratorContainer);
        maxX.init(w);
        maxX.addSelfPosition(leftWidth, 15);
        addWidget(maxX);

        var maxY = new NumberConfigurator("maxY", () -> this.value.f_82292_, number -> {
            var newValue = new AABB(this.value.f_82288_, this.value.f_82289_, this.value.f_82290_, this.value.f_82291_, number.doubleValue(), this.value.f_82293_);
            onValueUpdate(newValue);
            updateValue();
        }, defaultValue.f_82292_, forceUpdate);
        maxY.setRange(-Double.MAX_VALUE, Double.MAX_VALUE);
        maxY.setWheel(0.1);
        maxY.setConfiguratorContainer(configuratorContainer);
        maxY.init(w);
        maxY.addSelfPosition(leftWidth + w, 15);
        addWidget(maxY);

        var maxZ = new NumberConfigurator("maxZ", () -> this.value.f_82293_, number -> {
            var newValue = new AABB(this.value.f_82288_, this.value.f_82289_, this.value.f_82290_, this.value.f_82291_, this.value.f_82292_, number.doubleValue());
            onValueUpdate(newValue);
            updateValue();
        }, defaultValue.f_82293_, forceUpdate);
        maxZ.setRange(-Double.MAX_VALUE, Double.MAX_VALUE);
        maxZ.setWheel(0.1);
        maxZ.setConfiguratorContainer(configuratorContainer);
        maxZ.init(w);
        maxZ.addSelfPosition(leftWidth + w * 2, 15);
        addWidget(maxZ);
    }

}
