package com.lowdragmc.lowdraglib.gui.editor.configurator;

import com.lowdragmc.lowdraglib.gui.editor.ColorPattern;
import com.lowdragmc.lowdraglib.gui.texture.ItemStackTexture;
import com.lowdragmc.lowdraglib.gui.widget.ImageWidget;
import com.lowdragmc.lowdraglib.gui.widget.SearchComponentWidget;
import com.lowdragmc.lowdraglib.gui.widget.TextFieldWidget;
import com.lowdragmc.lowdraglib.side.fluid.FluidStack;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.material.Fluid;

import javax.annotation.Nonnull;
import java.util.Map.Entry;
import java.util.function.Consumer;
import java.util.function.Supplier;

public class FluidConfigurator extends ValueConfigurator<Fluid> implements SearchComponentWidget.IWidgetSearch<Fluid> {
    protected SearchComponentWidget<Fluid> searchComponent;
    protected ImageWidget image;

    public FluidConfigurator(String name, Supplier<Fluid> supplier, Consumer<Fluid> onUpdate, @Nonnull Fluid defaultValue, boolean forceUpdate) {
        super(name, supplier, onUpdate, defaultValue, forceUpdate);
        if (value == null) {
            value = defaultValue;
        }
    }

    @Override
    protected void onValueUpdate(Fluid newValue) {
        if (newValue == null) newValue = defaultValue;
        if (value == newValue) return;
        super.onValueUpdate(newValue);
        searchComponent.setCurrent(value == null ? defaultValue : value);
    }

    @Override
    public void init(int width) {
        super.init(width);
        addWidget(image = new ImageWidget(leftWidth, 2, width - leftWidth - 3 - rightWidth, 10, ColorPattern.T_GRAY.rectTexture().setRadius(5)));
        image.setDraggingConsumer(
                o -> o instanceof Fluid || o instanceof FluidStack,
                o -> image.setImage(ColorPattern.GREEN.rectTexture().setRadius(5)),
                o -> image.setImage(ColorPattern.T_GRAY.rectTexture().setRadius(5)),
                o -> {
                    if (o instanceof FluidStack fluidStack) {
                        onValueUpdate(fluidStack.getFluid());
                        updateValue();
                    } else if (o instanceof Fluid fluid) {
                        onValueUpdate(fluid);
                        updateValue();
                    }
                    image.setImage(ColorPattern.T_GRAY.rectTexture().setRadius(5));
                });
        addWidget(searchComponent = new SearchComponentWidget<>(leftWidth + 3, 2, width - leftWidth - 6 - rightWidth, 10, this));
        searchComponent.setIconProvider(fluid -> new ItemStackTexture(fluid.m_6859_()));
        searchComponent.setShowUp(true);
        searchComponent.setCapacity(5);
        searchComponent.setCurrent(value);
        var textFieldWidget = searchComponent.textFieldWidget;
        textFieldWidget.setClientSideWidget();
        textFieldWidget.setBordered(false);
    }


    @Override
    public String resultDisplay(Fluid fluid) {
        return BuiltInRegistries.f_257020_.m_7981_(fluid).toString();
    }

    @Override
    public void selectResult(Fluid value) {
        onValueUpdate(value);
        updateValue();
    }

    @Override
    public void search(String word, Consumer<Fluid> find) {
        var wordLower = word.toLowerCase();
        for (var entry : BuiltInRegistries.f_257020_.m_6579_()) {
            if (Thread.currentThread().isInterrupted()) return;
            var fluid = entry.getValue();
            var id = entry.getKey().m_135782_();
            if (id.toString().contains(wordLower)) {
                find.accept(fluid);
            }
        }
    }
}
