package com.lowdragmc.lowdraglib.gui.factory;

import com.lowdragmc.lowdraglib.LDLib;
import com.lowdragmc.lowdraglib.gui.modular.IUIHolder;
import com.lowdragmc.lowdraglib.gui.modular.ModularUI;
import net.minecraft.client.Minecraft;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;

public class BlockEntityUIFactory extends UIFactory<BlockEntity>{
    public static final BlockEntityUIFactory INSTANCE  = new BlockEntityUIFactory();

    private BlockEntityUIFactory() {
        super(LDLib.location("block_entity"));
    }

    @Override
    protected ModularUI createUITemplate(BlockEntity holder, Player entityPlayer) {
        if (holder instanceof IUIHolder) {
            return ((IUIHolder) holder).createUI(entityPlayer);
        }
        return null;
    }

    @Environment(EnvType.CLIENT)
    @Override
    protected BlockEntity readHolderFromSyncData(FriendlyByteBuf syncData) {
        Level world = Minecraft.m_91087_().f_91073_;
        return world == null ? null : world.m_7702_(syncData.m_130135_());
    }

    @Override
    protected void writeHolderToSyncData(FriendlyByteBuf syncData, BlockEntity holder) {
        syncData.m_130064_(holder.m_58899_());
    }
}
