package com.lowdragmc.lowdraglib.gui.factory;

import com.lowdragmc.lowdraglib.LDLib;
import com.lowdragmc.lowdraglib.gui.modular.IUIHolder;
import com.lowdragmc.lowdraglib.gui.modular.ModularUI;
import lombok.Getter;
import net.minecraft.client.Minecraft;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;

/**
 * @author KilaBash
 * @date 2022/8/26
 * @implNote ItemUIFactory
 */
public class HeldItemUIFactory extends UIFactory<HeldItemUIFactory.HeldItemHolder> {

    public static final HeldItemUIFactory INSTANCE = new HeldItemUIFactory();

    public HeldItemUIFactory() {
        super(LDLib.location("held_item"));
    }

    public final boolean openUI(ServerPlayer player, InteractionHand hand) {
        return openUI(new HeldItemHolder(player, hand), player);
    }

    @Override
    protected ModularUI createUITemplate(HeldItemHolder holder, Player entityPlayer) {
        return holder.createUI(entityPlayer);
    }

    @Override
    @Environment(EnvType.CLIENT)
    protected HeldItemHolder readHolderFromSyncData(FriendlyByteBuf syncData) {
        Player player = Minecraft.m_91087_().f_91074_;
        return player == null ? null :new HeldItemHolder(player, syncData.m_130066_(InteractionHand.class));
    }

    @Override
    protected void writeHolderToSyncData(FriendlyByteBuf syncData, HeldItemHolder holder) {
        syncData.m_130068_(holder.hand);
    }

    @Getter
    public static class HeldItemHolder implements IUIHolder {
        public Player player;
        public InteractionHand hand;
        public ItemStack held;

        public HeldItemHolder(Player player, InteractionHand hand) {
            this.player = player;
            this.hand = hand;
            held = player.m_21120_(hand);
        }

        @Override
        public ModularUI createUI(Player entityPlayer) {
            if (held.m_41720_() instanceof IHeldItemUIHolder itemUIHolder) {
                return itemUIHolder.createUI(entityPlayer, this);
            }
            return null;
        }

        @Override
        public boolean isInvalid() {
            return !ItemStack.m_150942_(player.m_21120_(hand), held);
        }

        @Override
        public boolean isRemote() {
            return player.m_9236_().f_46443_;
        }

        @Override
        public void markAsDirty() {

        }

    }

    @Deprecated
    public interface IHeldItemUIHolder extends IUIHolder.ItemUI {

    }
}
