package com.lowdragmc.lowdraglib.gui.graphprocessor.nodes.minecraft;

import com.lowdragmc.lowdraglib.gui.editor.annotation.LDLRegister;
import com.lowdragmc.lowdraglib.gui.graphprocessor.annotation.InputPort;
import com.lowdragmc.lowdraglib.gui.graphprocessor.annotation.OutputPort;
import com.lowdragmc.lowdraglib.gui.graphprocessor.data.BaseNode;
import net.minecraft.world.level.Level;

@LDLRegister(name = "level info", group = "graph_processor.node.minecraft")
public class LevelInfoNode extends BaseNode {
    @InputPort
    public Level level;
    @OutputPort
    public int height;
    @OutputPort(name = "day time")
    public int dayTime;
    @OutputPort(name = "rain level")
    public float rainLevel;
    @OutputPort(name = "thunder level")
    public float thunderLevel;
    @OutputPort(name = "is day")
    public boolean isDay;

    @Override
    public void process() {
        if (level != null) {
            rainLevel = level.m_46722_(0);
            thunderLevel = level.m_46661_(0);
            height = level.m_141928_();
            dayTime = (int) level.m_46468_();
            isDay = level.m_46461_();
        }
    }
}
