package com.lowdragmc.lowdraglib.gui.graphprocessor.nodes.minecraft.data;

import com.lowdragmc.lowdraglib.gui.editor.annotation.ConfigSetter;
import com.lowdragmc.lowdraglib.gui.editor.annotation.Configurable;
import com.lowdragmc.lowdraglib.gui.editor.annotation.LDLRegister;
import com.lowdragmc.lowdraglib.gui.editor.configurator.ConfiguratorGroup;
import com.lowdragmc.lowdraglib.gui.editor.configurator.StringConfigurator;
import com.lowdragmc.lowdraglib.gui.graphprocessor.annotation.CustomPortBehavior;
import com.lowdragmc.lowdraglib.gui.graphprocessor.annotation.CustomPortOutput;
import com.lowdragmc.lowdraglib.gui.graphprocessor.annotation.InputPort;
import com.lowdragmc.lowdraglib.gui.graphprocessor.annotation.OutputPort;
import com.lowdragmc.lowdraglib.gui.graphprocessor.data.BaseNode;
import com.lowdragmc.lowdraglib.gui.graphprocessor.data.NodePort;
import com.lowdragmc.lowdraglib.gui.graphprocessor.data.PortData;
import com.lowdragmc.lowdraglib.gui.graphprocessor.data.PortEdge;
import com.lowdragmc.lowdraglib.syncdata.annotation.Persisted;
import net.minecraft.nbt.*;

import java.util.Collections;
import java.util.List;

@LDLRegister(name = "compound reader", group = "graph_processor.node.minecraft.data")
public class CompoundReaderNode extends BaseNode {
    public enum Type {
        STRING,
        NUMBER,
        BOOL,
        COMPOUND,
        LIST,

    }
    @InputPort
    public CompoundTag tag;
    @InputPort
    public String key;
    @OutputPort
    public Object out;
    @Configurable(showName = false)
    public Type type = Type.STRING;
    @Persisted
    public String internalKey = "";

    @Override
    public void buildConfigurator(ConfiguratorGroup father) {
        super.buildConfigurator(father);
        for (var port : getInputPorts()) {
            if (port.fieldName.equals("key")) {
                if (port.getEdges().isEmpty()) {
                    var stringConfigurator = new StringConfigurator("key", () -> internalKey, s -> internalKey = s, "", true);
                    father.addConfigurators(stringConfigurator);
                }
            }
        }
    }

    @Override
    public int getMinWidth() {
        return 120;
    }

    @Override
    public void process() {
        if (tag == null) {
            out = null;
            return;
        }
        var realKey = key;
        if (realKey == null) {
            realKey = internalKey;
        }
        if (type == Type.STRING) {
            out = tag.m_128461_(realKey);
        } else if (type == Type.NUMBER) {
            out = tag.m_128457_(realKey);
        } else if (type == Type.BOOL) {
            out = tag.m_128471_(realKey);
        } else if (type == Type.COMPOUND) {
            out = tag.m_128469_(realKey);
        } else if (type == Type.LIST) {
            if (tag.m_128423_(realKey) instanceof ListTag listTag) {
                switch (listTag.m_7264_()) {
                    case Tag.f_178201_ -> out = listTag.stream().map(Tag::m_7916_).toList();
                    case Tag.f_178198_ -> out = listTag.stream().map(FloatTag.class::cast).map(FloatTag::m_7057_).toList();
                    case Tag.f_178199_ -> out = listTag.stream().map(DoubleTag.class::cast).map(DoubleTag::m_7057_).toList();
                    case Tag.f_178196_ -> out = listTag.stream().map(IntTag.class::cast).map(IntTag::m_7057_).toList();
                    case Tag.f_178197_ -> out = listTag.stream().map(LongTag.class::cast).map(LongTag::m_7057_).toList();
                    case Tag.f_178195_ -> out = listTag.stream().map(ShortTag.class::cast).map(ShortTag::m_7057_).toList();
                    case Tag.f_178203_ -> out = listTag.stream().map(CompoundTag.class::cast).toList();
                    case Tag.f_178194_ -> out = listTag.stream().map(ByteTag.class::cast).map(t -> t.m_7063_() != 0).toList();
                    case Tag.f_178202_ -> out = listTag.stream().map(ListTag.class::cast).toList();
                    default -> out = Collections.emptyList();
                }
            }
        }
    }

    public Class<?> getDisplayType() {
        return switch (type) {
            case STRING -> String.class;
            case NUMBER -> Float.class;
            case BOOL -> Boolean.class;
            case COMPOUND -> CompoundTag.class;
            case LIST -> List.class;
        };
    }

    @ConfigSetter(field = "type")
    public void setType(Type type) {
        this.type = type;
        for (var outputPort : getOutputPorts()) {
            outputPort.portData.displayType = getDisplayType();
        }
    }

    @CustomPortBehavior(field = "out")
    public List<PortData> modifyOutPort(List<PortEdge> edges) {
        return List.of(new PortData()
                .displayName("out")
                .identifier("out")
                .acceptMultipleEdges(true)
                .displayType(getDisplayType()));
    }

    @CustomPortOutput(field = "out")
    public void pushOut(List<PortEdge> outputEdges, NodePort outputPort) {
        for (var edge : outputEdges) {
            edge.passThroughBuffer = out;
        }
    }



}
