package com.lowdragmc.lowdraglib.gui.graphprocessor.nodes.minecraft.data;

import com.lowdragmc.lowdraglib.gui.editor.annotation.Configurable;
import com.lowdragmc.lowdraglib.gui.editor.annotation.LDLRegister;
import com.lowdragmc.lowdraglib.gui.editor.configurator.ConfiguratorGroup;
import com.lowdragmc.lowdraglib.gui.graphprocessor.annotation.InputPort;
import com.lowdragmc.lowdraglib.gui.graphprocessor.annotation.OutputPort;
import com.lowdragmc.lowdraglib.gui.graphprocessor.data.trigger.LinearTriggerNode;
import net.minecraft.nbt.*;

import java.util.List;

@LDLRegister(name = "compound writer", group = "graph_processor.node.minecraft.data")
public class CompoundWriterNode extends LinearTriggerNode {
    @InputPort
    public CompoundTag tag;
    @InputPort
    public String key;
    @InputPort
    public Object value;
    @OutputPort
    public CompoundTag out;
    @Configurable(name = "key")
    public String internalKey = "";

    @Override
    public void process() {
        if (tag == null) {
            return;
        }
        out = tag.m_6426_();
        var realKey = key;
        if (realKey == null) {
            realKey = internalKey;
        }
        if (value instanceof String) {
            out.m_128359_(realKey, (String) value);
        } else if (value instanceof Number number) {
            out.m_128350_(realKey, number.floatValue());
        } else if (value instanceof Boolean) {
            out.m_128379_(realKey, (Boolean) value);
        } else if (value instanceof CompoundTag) {
            out.m_128365_(realKey, (CompoundTag) value);
        } else if (value instanceof List<?> list) {
            var listTag = new ListTag();
            dfsList(listTag, list);
            out.m_128365_(realKey, listTag);
        }
    }

    public void dfsList(ListTag listTag, List<?> list) {
        for (var element : list) {
            if (element instanceof String) {
                listTag.add(StringTag.m_129297_((String) element));
            } else if (element instanceof Number number) {
                listTag.add(FloatTag.m_128566_(number.floatValue()));
            } else if (element instanceof Boolean v) {
                listTag.add(ByteTag.m_128273_(v));
            } else if (element instanceof CompoundTag) {
                listTag.add((CompoundTag) element);
            } else if (element instanceof List<?> subList) {
                var subListTag = new ListTag();
                dfsList(subListTag, subList);
                listTag.add(subListTag);
            }
        }
    }

    @Override
    public void buildConfigurator(ConfiguratorGroup father) {
        for (var port : getInputPorts()) {
            if (port.fieldName.equals("key")) {
                if (!port.getEdges().isEmpty()) return;
            }
        }
        super.buildConfigurator(father);
    }
}
