package com.lowdragmc.lowdraglib.gui.graphprocessor.nodes.minecraft.entity;

import com.lowdragmc.lowdraglib.gui.editor.annotation.LDLRegister;
import com.lowdragmc.lowdraglib.gui.graphprocessor.annotation.InputPort;
import com.lowdragmc.lowdraglib.gui.graphprocessor.annotation.OutputPort;
import com.lowdragmc.lowdraglib.gui.graphprocessor.data.BaseNode;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.level.Level;
import org.joml.Vector3f;

@LDLRegister(name = "entity info", group = "graph_processor.node.minecraft.entity")
public class EntityInfoNode extends BaseNode {
    @InputPort
    public Object in;
    @OutputPort(name = "entity type")
    public EntityType entityType;
    @OutputPort(name = "is alive")
    public boolean isAlive;
    @OutputPort
    public Vector3f xyz;
    @OutputPort
    public Level level;
    @OutputPort
    public CompoundTag tag;

    @Override
    public void process() {
        if (in instanceof Entity entity) {
            entityType = entity.m_6095_();
            isAlive = entity.m_6084_();
            xyz = new Vector3f((float) entity.m_20185_(), (float) entity.m_20186_(), (float) entity.m_20189_());
            level = entity.m_9236_();
            tag = entity.m_20240_(new CompoundTag());
        }
    }
}
